/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.ecmascript6.ES6SpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSXSpecificHandlersFactory
extends ES6SpecificHandlersFactory {
    @Override
    @NotNull
    public ExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent) {
        JSXExpectedTypeEvaluator jSXExpectedTypeEvaluator = new JSXExpectedTypeEvaluator(parent);
        if (jSXExpectedTypeEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/JSXSpecificHandlersFactory", "newExpectedTypeEvaluator"));
        }
        return jSXExpectedTypeEvaluator;
    }

    private static class JSXExpectedTypeEvaluator
    extends ExpectedTypeEvaluator {
        private static final String[] STYLES = new String[]{"Image", "ScrollView", "Text"};

        public JSXExpectedTypeEvaluator(JSExpression parent) {
            super(parent);
        }

        @Override
        public JSType findExpectedType() {
            JSCallExpression call;
            if (this.myParent instanceof JSObjectLiteralExpression && this.myGrandParent instanceof JSProperty && (call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSCallExpression.class, (boolean)true, (Class[])new Class[]{JSExecutionScope.class})) != null && call.getMethodExpression() instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)call.getMethodExpression(), "StyleSheet", "create")) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this.myParent, true);
                ArrayList<JSType> styles = new ArrayList<JSType>(STYLES.length);
                for (String style : STYLES) {
                    styles.add(JSNamedType.createType("__React." + style + "Style", source, JSContext.INSTANCE));
                    styles.add(JSNamedType.createType("React." + style + "Style", source, JSContext.INSTANCE));
                }
                return new JSCompositeTypeImpl(source, (List<JSType>)styles);
            }
            return super.findExpectedType();
        }
    }
}

