/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSuperClassIndex;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ReactComponentUtil {
    public static final String COMPONENT_CLASS_NAME = "Component";

    public static Collection<JSClass> getReactComponents(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactComponentUtil", "getReactComponents"));
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        Collection candidates = StubIndex.getElements(JSSuperClassIndex.KEY, (Object)COMPONENT_CLASS_NAME, (Project)context.getProject(), (GlobalSearchScope)scope, JSClass.class);
        return candidates.stream().filter(el -> {
            PsiFile file = el.getContainingFile();
            if (!(file instanceof JSFile)) {
                return false;
            }
            JSFile jsFile = (JSFile)file;
            if (!jsFile.isCommonJSModule()) {
                return false;
            }
            return el.getName() != null && ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)el);
        }).collect(Collectors.toList());
    }
}

