/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlElementNSDescriptor
implements XmlNSDescriptor {
    private final Function<JSElement, XmlElementDescriptor> ELEMENT_DESCRIPTOR_MAPPER;
    @Nullable
    private final XmlNSDescriptor myParentDescriptor;
    @NotNull
    private final PsiElement myContext;
    private final boolean myIsStrict;

    ReactXmlElementNSDescriptor(@Nullable XmlNSDescriptor parentDescriptor, @NotNull PsiElement context, boolean strict) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementNSDescriptor", "<init>"));
        }
        this.ELEMENT_DESCRIPTOR_MAPPER = new Function<JSElement, XmlElementDescriptor>(){

            public XmlElementDescriptor fun(JSElement element) {
                String elementName = element.getName();
                assert (elementName != null);
                return new ReactXmlElementDescriptor(elementName, (PsiElement)element, ReactXmlElementNSDescriptor.this.myParentDescriptor, ReactXmlElementNSDescriptor.this.myIsStrict);
            }
        };
        this.myParentDescriptor = parentDescriptor;
        this.myContext = context;
        this.myIsStrict = strict;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementNSDescriptor", "getElementDescriptor"));
        }
        return new ReactXmlElementDescriptor(tag.getName(), (PsiElement)tag, this.myParentDescriptor, this.myIsStrict);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        Object[] descriptors = (XmlElementDescriptor[])ContainerUtil.map2Array(TypeScriptReactTagUtil.getAllTags(this.myContext), XmlElementDescriptor.class, this.ELEMENT_DESCRIPTOR_MAPPER);
        if (this.myIsStrict || this.myParentDescriptor == null) {
            if (descriptors == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementNSDescriptor", "getRootElementsDescriptors"));
            }
            return descriptors;
        }
        Object[] parentDescriptors = this.myParentDescriptor.getRootElementsDescriptors(document);
        XmlElementDescriptor[] xmlElementDescriptorArray = (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])parentDescriptors);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementNSDescriptor", "getRootElementsDescriptors"));
        }
        return xmlElementDescriptorArray;
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return XmlUtil.findXmlFile((PsiFile)this.myContext.getContainingFile(), (String)Html5SchemaProvider.getHtml5SchemaLocation());
    }

    public PsiElement getDeclaration() {
        return null;
    }

    public String getName(PsiElement context) {
        return null;
    }

    public String getName() {
        return null;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

