/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import java.util.Collection;

public class JavaScriptOverrideMethodsHandler
extends BaseJSGenerateHandler {
    @Override
    protected String getTitleKey() {
        return "methods.to.override.chooser.title";
    }

    @Override
    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.methods.to.override", (Object[])new Object[0]);
    }

    @Override
    protected BaseCreateMethodsFix createFix(JSClass clazz) {
        return new OverrideMethodsFix(clazz);
    }

    @Override
    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
        for (JSFunction function : JSInheritanceUtil.collectFunctionsToOverride(clazz)) {
            candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)function));
        }
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }
}

