/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.flags;

import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import org.jetbrains.annotations.NotNull;

public class EnumStructureElement<T extends Enum<T>>
extends FlagsStructureElement<T> {
    private final Class<T> myEnumClass;

    public EnumStructureElement(Class<T> enumClass) {
        super(EnumStructureElement.binaryLog(((Enum[])enumClass.getEnumConstants()).length));
        this.myEnumClass = enumClass;
    }

    @Override
    @NotNull
    public T getObject(int value) {
        Enum enum_ = ((Enum[])this.myEnumClass.getEnumConstants())[value];
        if (enum_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/flags/EnumStructureElement", "getObject"));
        }
        return (T)enum_;
    }

    @Override
    public int getValue(T object) {
        return ((Enum)object).ordinal();
    }

    public Class<T> getEnumClass() {
        return this.myEnumClass;
    }
}

