/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.flags;

import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class FlagsStructure {
    public static final FlagsStructure EMPTY = new FlagsStructure(new FlagsStructureElement[0]);
    @NotNull
    private final FlagsStructureElement[] myElements;

    public FlagsStructure(FlagsStructureElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/index/flags/FlagsStructure", "<init>"));
        }
        this.myElements = elements;
    }

    public FlagsStructure(@NotNull FlagsStructure baseStructure, FlagsStructureElement ... elements) {
        if (baseStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseStructure", "com/intellij/lang/javascript/index/flags/FlagsStructure", "<init>"));
        }
        this.myElements = (FlagsStructureElement[])ArrayUtil.mergeArrays((Object[])baseStructure.getElements(), (Object[])elements);
    }

    public int size() {
        int result = 0;
        for (FlagsStructureElement element : this.myElements) {
            result += element.size();
        }
        return result;
    }

    @NotNull
    public FlagsStructureElement[] getElements() {
        if (this.myElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/flags/FlagsStructure", "getElements"));
        }
        return this.myElements;
    }
}

