/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.inspections.JSUnresolvedLibraryURLInspection;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadLibraryQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(JSUnresolvedLibraryURLInspection.class);
    private String myTestRoot;

    public void setTestRoot(String testRoot) {
        this.myTestRoot = testRoot;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.library.download.fix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "applyFix"));
        }
        PsiElement attrValue = descriptor.getPsiElement();
        if (attrValue != null) {
            String location = StringUtil.unquoteString((String)attrValue.getText());
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            PsiFile psiFile = attrValue.getContainingFile();
            this.download(editor, project, psiFile != null ? psiFile.getVirtualFile() : null, location);
        }
    }

    public void download(final @Nullable Editor editor, final @NotNull Project project, final @Nullable VirtualFile referencingFile, final @NotNull String libraryFileUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "download"));
        }
        if (libraryFileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFileUrl", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "download"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JSDownloadManager downloadManager = new JSDownloadManager(this.myTestRoot);
            String targetPath = downloadManager.download(libraryFileUrl, "");
            if (StringUtil.isNotEmpty((String)targetPath)) {
                DownloadLibraryQuickFix.addLibrary(project, referencingFile, libraryFileUrl, targetPath);
            }
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, "Downloading Library", true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix$1", "run"));
                }
                JSDownloadManager downloadManager = new JSDownloadManager(DownloadLibraryQuickFix.this.myTestRoot);
                downloadManager.setProgressIndicator(indicator);
                JSDownloadManager.JSDownloadException exception = null;
                String downloadedLibraryFilePath = null;
                boolean tryAgain = true;
                while (tryAgain) {
                    downloadedLibraryFilePath = downloadManager.download(libraryFileUrl, "");
                    exception = downloadManager.getLastException();
                    if (exception == null) break;
                    String reason = exception.getReason();
                    String dialogText = reason.contains(libraryFileUrl) ? reason : "Failed to download " + libraryFileUrl + ". " + reason;
                    tryAgain = IOExceptionDialog.showErrorDialog((String)"Download Error", (String)dialogText);
                }
                if (exception != null) {
                    LOG.info(exception);
                } else {
                    DownloadLibraryQuickFix.addLibrary(project, referencingFile, libraryFileUrl, (String)ObjectUtils.assertNotNull((Object)downloadedLibraryFilePath));
                    if (editor != null) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix$1", "lambda$run$0"));
                            }
                            DownloadLibraryQuickFix.showStatus(project, editor, "Successfully downloaded " + downloadManager.getActualSource(), MessageType.INFO);
                        });
                    }
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    private static void showStatus(Project project, Editor editor, String message, MessageType messageType) {
        JComponent component = editor.getComponent();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).createBalloon();
        Point p = editor.logicalPositionToXY(editor.getCaretModel().getLogicalPosition());
        p.translate(0, 20);
        RelativePoint point = new RelativePoint((Component)component, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)project, (Disposable)balloon);
    }

    private static void addLibrary(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryFileUrl, @NotNull String downloadedLibraryFilePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "addLibrary"));
        }
        if (libraryFileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFileUrl", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "addLibrary"));
        }
        if (downloadedLibraryFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadedLibraryFilePath", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "addLibrary"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "lambda$addLibrary$0"));
            }
            if (libraryFileUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFileUrl", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "lambda$addLibrary$0"));
            }
            if (downloadedLibraryFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadedLibraryFilePath", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "lambda$addLibrary$0"));
            }
            DownloadLibraryQuickFix.doAddLibrary(project, referencingFile, libraryFileUrl, downloadedLibraryFilePath);
        }, project.getDisposed());
    }

    private static void doAddLibrary(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryFileUrl, @NotNull String downloadedLibraryFilePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "doAddLibrary"));
        }
        if (libraryFileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFileUrl", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "doAddLibrary"));
        }
        if (downloadedLibraryFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadedLibraryFilePath", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "doAddLibrary"));
        }
        File libFile = new File(downloadedLibraryFilePath);
        assert (libFile.exists()) : "Library file does not exist at " + downloadedLibraryFilePath;
        VirtualFile librarySourceFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libFile));
        if (librarySourceFile == null || !librarySourceFile.exists()) {
            LOG.error("Library file not found: " + downloadedLibraryFilePath + ", file = " + libraryFileUrl);
            return;
        }
        String libraryName = JSLibraryUtil.getLibName(libraryFileUrl);
        List<VirtualFile> roots = DownloadLibraryQuickFix.getRootsToAssociateWith(project, referencingFile, libraryName);
        if (roots == null) {
            return;
        }
        WriteAction.run(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "lambda$doAddLibrary$2"));
            }
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libraryName);
            if (library == null) {
                String[] stringArray;
                String key;
                String libUrl = VfsUtilCore.pathToUrl((String)libFile.getAbsolutePath());
                String docUrl = null;
                ScriptingFrameworkDescriptor framework = JSProjectUtil.detectFramework(libUrl);
                if (framework != null && (key = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion())) != null) {
                    docUrl = JSExternalLibraryDocBundle.getBaseUrl(key);
                }
                VirtualFile[] virtualFileArray = new VirtualFile[]{librarySourceFile};
                if (docUrl == null) {
                    stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = docUrl;
                }
                ScriptingLibraryModel model = libraryManager.createLibrary(libraryName, virtualFileArray, VirtualFile.EMPTY_ARRAY, stringArray, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                model.setFrameworkDescriptor(framework);
                ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
                for (VirtualFile root : roots) {
                    mappings.associate(root, libraryName);
                }
                libraryManager.commitChanges();
            } else {
                ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
                ScriptingLibraryModel model = libraryTable.getModel(library);
                if (model != null && model.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
                    Set sources = model.getSourceFiles();
                    HashSet result = ContainerUtil.newHashSet((Iterable)sources);
                    result.add(librarySourceFile);
                    model.setSourceFiles(VfsUtilCore.toVirtualFileArray((Collection)result));
                    libraryManager.commitChanges();
                }
            }
        });
    }

    @Nullable
    private static List<VirtualFile> getRootsToAssociateWith(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "getRootsToAssociateWith"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix", "getRootsToAssociateWith"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList(null);
        }
        ModuleScopeSelectionView view = new ModuleScopeSelectionView(project, referencingFile, true, false);
        if (view.isAssociateWithProjectView()) {
            return view.getLibraryScope();
        }
        ModuleScopeSelectionDialog dialog = new ModuleScopeSelectionDialog(project, libraryName, view);
        if (dialog.showAndGet()) {
            return dialog.getView().getLibraryScope();
        }
        return null;
    }
}

