/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.ES6InsertAwaitFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MissingAwaitInspection
extends JSInspection {
    public static final String SHORT_NAME = ES6MissingAwaitInspection.calcShortNameFromClass(ES6MissingAwaitInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                ResolveResult[] results;
                DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)node);
                if (optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.ASYNC_AWAIT)) {
                    return;
                }
                super.visitJSCallExpression(node);
                PsiElement parent = JSUtils.getParentSkipParentheses((PsiElement)node);
                if (!ES6MissingAwaitInspection.needProcess(node, parent)) {
                    return;
                }
                PsiElement scope = JSPsiImplUtils.getExecutionScope((PsiElement)node);
                if (!(scope instanceof JSFunction)) {
                    return;
                }
                if (!ES6PsiUtil.isAsyncContext((JSFunction)scope)) {
                    return;
                }
                JSExpression methodExpression = node.getMethodExpression();
                boolean isAsyncFunctionCall = false;
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return;
                }
                for (ResolveResult result : results = ((JSReferenceExpression)methodExpression).multiResolve(false)) {
                    JSType jsType;
                    JSTypeEvaluationResult type;
                    if (!result.isValidResult()) continue;
                    PsiElement source = result.getElement();
                    if (source != null && !(source instanceof JSFunction)) {
                        source = JSPsiImplUtils.calculatePossibleFunction(source, (PsiElement)methodExpression);
                    }
                    if (source instanceof JSFunction && ES6PsiUtil.isAsyncContext((JSFunction)source) && (type = JSTypeEvaluator.getExpressionType(methodExpression)) != null && (jsType = type.getType()) != null && jsType.getSource().isExplicitlyDeclared()) {
                        isAsyncFunctionCall = true;
                        continue;
                    }
                    return;
                }
                if (!isAsyncFunctionCall) {
                    return;
                }
                holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.missing.await.symbol.inspection.name", (Object[])new Object[0]), new LocalQuickFix[]{new ES6InsertAwaitFix(node)});
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static boolean needProcess(@NotNull JSCallExpression element, @Nullable PsiElement parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection", "needProcess"));
        }
        if (parent == null || parent instanceof JSArgumentList || parent instanceof JSAssignmentExpression || parent instanceof JSReferenceExpression || parent instanceof JSFile) {
            return false;
        }
        if (ES6PsiUtil.isAwaitExpression(parent)) {
            return false;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() != null) {
            return false;
        }
        if (parent instanceof JSArrayLiteralExpression) {
            return ES6MissingAwaitInspection.needProcess(element, JSUtils.getParentSkipParentheses(parent));
        }
        if (parent instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)parent;
            if (conditionalExpression.getCondition() == element) {
                return true;
            }
            return ES6MissingAwaitInspection.needProcess(element, JSUtils.getParentSkipParentheses(parent));
        }
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.missing.await.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection", "getDisplayName"));
        }
        return string;
    }
}

