/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSFunctionExpressionToArrowFunctionQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JSFunctionExpressionToArrowFunctionInspection
extends JSInspection
implements ES6CoolRefactoring {
    private static TokenSet ourTokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.PARAMETER_LISTS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD})});

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                boolean anonymousNotArrow;
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionInspection$1", "visitJSFunctionExpression"));
                }
                super.visitJSFunctionExpression(node);
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                if (!new JSFunctionExpressionToArrowFunctionQuickFix.NameChecker(node).check()) {
                    return;
                }
                boolean bl = anonymousNotArrow = JSPsiImplUtils.isArrowFunction((JSFunction)node) == null;
                if (anonymousNotArrow && PsiTreeUtil.findChildOfType((PsiElement)node, JSThisExpression.class) == null) {
                    ASTNode astNode = node.getNode();
                    Object[] children = astNode.getChildren(ourTokenSet);
                    if (ArrayUtil.isEmpty((Object[])children)) {
                        return;
                    }
                    PsiElement lastElement = children[children.length - 1].getPsi();
                    int startOffset = children[0].getPsi().getStartOffsetInParent();
                    int endOffset = lastElement.getStartOffsetInParent() + lastElement.getTextLength();
                    holder.registerProblem((PsiElement)node, new TextRange(startOffset, endOffset), JSBundle.message((String)"js.inspection.function.expression.is.used.instead.of.arrow", (Object[])new Object[0]), new LocalQuickFix[]{new JSFunctionExpressionToArrowFunctionQuickFix((SmartPsiElementPointer<JSFunctionExpression>)SmartPointerManager.getInstance((Project)holder.getProject()).createSmartPsiElementPointer((PsiElement)node))});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

