/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSSharedUsageInformation {
    private static final Key<Reference<JSSharedUsageInformation>> JS_REF_COUNT_HOLDER_IN_FILE_KEY = Key.create((String)"JS_REF_COUNT_HOLDER_IN_FILE_KEY");
    private final Map<PsiAnchor, Boolean> myDclsUsedMap = ContainerUtil.newConcurrentMap();

    public static void clear(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSSharedUsageInformation", "clear"));
        }
        Reference ref = (Reference)file.getUserData(JS_REF_COUNT_HOLDER_IN_FILE_KEY);
        file.putUserData(JS_REF_COUNT_HOLDER_IN_FILE_KEY, null);
        JSSharedUsageInformation holder = (JSSharedUsageInformation)SoftReference.dereference((Reference)ref);
        if (holder != null) {
            holder.clear();
        }
    }

    @NotNull
    static JSSharedUsageInformation get(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSSharedUsageInformation", "get"));
        }
        Reference ref = (Reference)file.getUserData(JS_REF_COUNT_HOLDER_IN_FILE_KEY);
        JSSharedUsageInformation holder = (JSSharedUsageInformation)SoftReference.dereference((Reference)ref);
        if (holder == null) {
            boolean replaced;
            holder = new JSSharedUsageInformation();
            java.lang.ref.SoftReference<JSSharedUsageInformation> newRef = new java.lang.ref.SoftReference<JSSharedUsageInformation>(holder);
            while (!(replaced = ((UserDataHolderEx)file).replace(JS_REF_COUNT_HOLDER_IN_FILE_KEY, (Object)ref, newRef))) {
                ref = (Reference)file.getUserData(JS_REF_COUNT_HOLDER_IN_FILE_KEY);
                JSSharedUsageInformation newHolder = (JSSharedUsageInformation)SoftReference.dereference((Reference)ref);
                if (newHolder == null) continue;
                holder = newHolder;
                break;
            }
        }
        JSSharedUsageInformation jSSharedUsageInformation = holder;
        if (jSSharedUsageInformation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSSharedUsageInformation", "get"));
        }
        return jSSharedUsageInformation;
    }

    public void registerLocallyReferencedDeclaration(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSSharedUsageInformation", "registerLocallyReferencedDeclaration"));
        }
        this.myDclsUsedMap.put(PsiAnchor.create((PsiElement)element), Boolean.TRUE);
    }

    public void registerDeclaration(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSSharedUsageInformation", "registerDeclaration"));
        }
        this.myDclsUsedMap.putIfAbsent(PsiAnchor.create((PsiElement)element), Boolean.FALSE);
    }

    public boolean isReferenced(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSSharedUsageInformation", "isReferenced"));
        }
        return Boolean.TRUE.equals(this.myDclsUsedMap.get(PsiAnchor.create((PsiElement)element)));
    }

    public Map<PsiAnchor, Boolean> getDclsUsedMap() {
        return this.myDclsUsedMap;
    }

    public void clear() {
        this.myDclsUsedMap.clear();
    }

    public void removeUnused() {
        ArrayList<PsiAnchor> unused = new ArrayList<PsiAnchor>();
        for (Map.Entry<PsiAnchor, Boolean> entry : this.myDclsUsedMap.entrySet()) {
            if (Boolean.TRUE.equals(entry.getValue())) continue;
            unused.add(entry.getKey());
        }
        for (PsiAnchor anchor : unused) {
            this.myDclsUsedMap.remove(anchor);
        }
    }
}

