/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.intentions.JSStringTemplateConvertVisibilityOfLineSeparatorsIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSStringConcatenationToES6TemplateQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final SmartPsiElementPointer<JSExpression> myPointer;

    public JSStringConcatenationToES6TemplateQuickFix(@NotNull JSExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.replace.string.concatenation.with.es6.template", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.replace.string.concatenation.with.es6.template", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "isAvailable"));
        }
        JSExpression element = (JSExpression)this.myPointer.getElement();
        return element != null && element.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "invoke"));
        }
        this.applyImpl(project);
    }

    private void applyImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "applyImpl"));
        }
        JSExpression element = (JSExpression)this.myPointer.getElement();
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement replaced = JSStringConcatenationToES6TemplateHelper.findSuitableExpression((PsiElement)element);
        if (replaced != null) {
            JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.convert(project, replaced, (Convertor<String, String>)((Convertor)s -> s.replace("\\n", "\n")));
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateQuickFix", "applyFix"));
        }
        this.applyImpl(project);
    }
}

