/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibReferenceResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSUnresolvedLibraryURLInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiReference libRef;
                XmlAttributeValue valueElement;
                if (HtmlUtil.isScriptTag((XmlTag)attribute.getParent()) && "src".equals(attribute.getName()) && (valueElement = attribute.getValueElement()) != null && JSLibraryUtil.containsLibURL(valueElement.getValue()) && ((libRef = JSLibReferenceResolver.getLibReference(valueElement)) == null || libRef.resolve() == null)) {
                    holder.registerProblem((PsiElement)valueElement, JSUnresolvedLibraryURLInspection.this.getDisplayName(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, attribute.getValueTextRange(), new LocalQuickFix[]{JSFixFactory.getInstance().downloadLibraryQuickFix()});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection", "createVisitor"));
        }
        return xmlElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.library.unresolved.url.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection", "getDisplayName"));
        }
        return string;
    }
}

