/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSSharedUsageInformation;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalDeclarationsCache;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedGlobalSymbolsInspection
extends JSInspection {
    public boolean myReportUnusedDefinitions;
    public boolean myReportUnusedProperties;
    private static ImplicitUsageProvider[] myExtensions = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);
    private HashSet<JSNamedElement> myRecheck = new HashSet();

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.global.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        Consumer reporter = element -> JSUnusedGlobalSymbolsInspection.registerProblem(element, holder);
        if (holder.isOnTheFly() && Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            MyReadingCacheVisitor myReadingCacheVisitor = new MyReadingCacheVisitor(session.getFile(), (Consumer<PsiElement>)reporter, this.myReportUnusedDefinitions, this.myReportUnusedProperties, this.myRecheck);
            if (myReadingCacheVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "createVisitor"));
            }
            return myReadingCacheVisitor;
        }
        MyJSElementVisitor myJSElementVisitor = new MyJSElementVisitor(session.getFile(), (Consumer<PsiElement>)reporter, this.myReportUnusedDefinitions, this.myReportUnusedProperties);
        if (myJSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "createVisitor"));
        }
        return myJSElementVisitor;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "inspectionStarted"));
        }
        super.inspectionStarted(session, isOnTheFly);
        if (Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            JSUnusedGlobalDeclarationsCache.getInstance(session.getFile().getProject()).restartFile(session.getFile().getVirtualFile());
        }
        this.myRecheck.clear();
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "inspectionFinished"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "inspectionFinished"));
        }
        if (Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            JSUnusedGlobalDeclarationsCache cache = JSUnusedGlobalDeclarationsCache.getInstance(session.getFile().getProject());
            try {
                Set<PsiElement> elements = cache.getUnusedDeclarationsFuture(session.getFile().getVirtualFile()).get();
                this.myRecheck.forEach(element -> {
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "lambda$inspectionFinished$1"));
                    }
                    if (elements.contains(element)) {
                        JSUnusedGlobalSymbolsInspection.registerProblem((PsiElement)element, holder);
                    }
                });
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        super.inspectionFinished(session, holder);
    }

    public static void registerProblem(PsiElement namedElement, @NotNull ProblemsHolder holder) {
        PsiElement nameIdentifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "registerProblem"));
        }
        String name = namedElement instanceof JSNamedElement ? ((JSNamedElement)namedElement).getName() : namedElement.getText();
        JSNamedElementKind namedElementKind = JSNamedElementKind.kind(namedElement, false);
        PsiElement psiElement = nameIdentifier = namedElement instanceof JSNamedElement ? ((JSNamedElement)namedElement).getNameIdentifier() : namedElement;
        if (nameIdentifier == null) {
            return;
        }
        FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(namedElementKind, name);
        fix.registerElementRefForFix(nameIdentifier, null);
        LocalQuickFix[] fixes = new LocalQuickFix[]{fix};
        holder.registerProblem(nameIdentifier, JSUnusedLocalSymbolsInspection.unusedMessage(namedElementKind), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
    }

    public static boolean calcUnused(PsiElement element, SearchScope scope) {
        return JSUnusedGlobalSymbolsInspection.calcUnused(element, element, scope);
    }

    private static boolean calcUnused(PsiElement element, PsiElement ignoreUsagesAmongChildrenOfThisElement, SearchScope scope) {
        for (ImplicitUsageProvider provider : myExtensions) {
            if (!provider.isImplicitUsage(element)) continue;
            return false;
        }
        boolean def = element instanceof JSDefinitionExpression;
        Query psiReferenceQuery = ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true);
        return psiReferenceQuery.forEach(psiReference -> {
            PsiElement parent;
            PsiElement psiElement = psiReference.getElement();
            if (JSResolveUtil.isSelfReference(psiElement) || JSUnusedGlobalSymbolsInspection.isSelfUsed(psiElement, ignoreUsagesAmongChildrenOfThisElement)) {
                return true;
            }
            return def && (parent = psiElement.getParent()) instanceof JSDefinitionExpression;
        });
    }

    private static boolean isSelfUsed(PsiElement psiElement, PsiElement ignoreUsagesAmongChildrenOfThisElement) {
        if (PsiTreeUtil.isAncestor((PsiElement)ignoreUsagesAmongChildrenOfThisElement, (PsiElement)psiElement, (boolean)false)) {
            if (ignoreUsagesAmongChildrenOfThisElement instanceof JSClass) {
                return true;
            }
            JSFunction callback = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSFunction.class);
            return callback == null || !PsiTreeUtil.isAncestor((PsiElement)ignoreUsagesAmongChildrenOfThisElement, (PsiElement)callback, (boolean)true);
        }
        return false;
    }

    public static GlobalSearchScope skipLibraryFiles(final @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "skipLibraryFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "skipLibraryFiles"));
        }
        return new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "contains"));
                }
                if (!super.contains(file)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile(file, project);
            }
        };
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.properties", (Object[])new Object[0]), "myReportUnusedProperties");
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.definitions", (Object[])new Object[0]), "myReportUnusedDefinitions");
        return optionsPanel;
    }

    private static boolean isLocalFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection", "isLocalFunctionExpression"));
        }
        PsiElement parent = node.getParent();
        return parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSCallExpression || parent instanceof JSArgumentList || parent instanceof JSReturnStatement || parent instanceof JSParenthesizedExpression && parent.getParent() instanceof JSCallExpression;
    }

    private static class MyReadingCacheVisitor
    extends MyJSElementVisitor {
        private JSUnusedGlobalDeclarationsCache myCache;
        @NotNull
        private final Set<JSNamedElement> myToRecheck;

        public MyReadingCacheVisitor(@NotNull PsiFile file, @NotNull Consumer<PsiElement> consumer, boolean reportUnusedDefintions, boolean reportUnusedProperties, @NotNull Set<JSNamedElement> toRecheck) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyReadingCacheVisitor", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyReadingCacheVisitor", "<init>"));
            }
            if (toRecheck == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRecheck", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyReadingCacheVisitor", "<init>"));
            }
            super(file, consumer, reportUnusedDefintions, reportUnusedProperties);
            this.myCache = JSUnusedGlobalDeclarationsCache.getInstance(file.getProject());
            this.myToRecheck = toRecheck;
        }

        @Override
        protected void checkUnused(JSNamedElement namedElement) {
            PsiFile psiFile = namedElement.getContainingFile();
            try {
                Future<Set<PsiElement>> future = this.myCache.getUnusedDeclarationsFuture(psiFile.getVirtualFile());
                if (future.isDone()) {
                    Set<PsiElement> set = future.get();
                    if (set.contains(namedElement)) {
                        this.myConsumer.consume((Object)namedElement);
                    }
                } else {
                    this.myToRecheck.add(namedElement);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                this.myToRecheck.add(namedElement);
            }
        }
    }

    public static class MyJSElementVisitor
    extends JSElementVisitor {
        @NotNull
        private final PsiFile myFile;
        ProgressIndicator progress;
        @NotNull
        protected final Consumer<PsiElement> myConsumer;
        private boolean myReportUnusedDefinitions;
        private boolean myReportUnusedProperties;

        public MyJSElementVisitor(@NotNull PsiFile file, @NotNull Consumer<PsiElement> consumer, boolean reportUnusedDefintions, boolean reportUnusedProperties) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "<init>"));
            }
            this.myFile = file;
            this.myConsumer = consumer;
            this.myReportUnusedDefinitions = reportUnusedDefintions;
            this.myReportUnusedProperties = reportUnusedProperties;
            this.progress = ProgressManager.getInstance().getProgressIndicator();
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            if (!JSResolveUtil.isSelfReference((PsiElement)node)) {
                if (node.getParent() instanceof ES6ExportDefaultAssignment && node.getReferenceName() != null) {
                    Project project = node.getProject();
                    GlobalSearchScope scopeForSearch = MyJSElementVisitor.getScopeForSearch((PsiElement)node, project);
                    if (scopeForSearch == null) {
                        return;
                    }
                    if (this.notCheap(node.getContainingFile(), node.getReferenceName(), project, scopeForSearch)) {
                        return;
                    }
                    boolean unused = JSUnusedGlobalSymbolsInspection.calcUnused((PsiElement)node, (SearchScope)scopeForSearch);
                    if (unused) {
                        this.myConsumer.consume((Object)node);
                    }
                }
                return;
            }
            JSNamedElement parent = (JSNamedElement)node.getParent();
            if (parent instanceof JSFunctionExpression) {
                return;
            }
            this.checkUnused(parent);
        }

        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "visitJSFunctionExpression"));
            }
            if (JSUnusedGlobalSymbolsInspection.isLocalFunctionExpression(node)) {
                return;
            }
            this.checkUnused((JSNamedElement)node);
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "visitJSFunctionDeclaration"));
            }
            this.checkUnused((JSNamedElement)node);
        }

        public void visitJSVariable(JSVariable node) {
            PsiElement nameIdentifier = node.getNameIdentifier();
            if (!(nameIdentifier instanceof JSReferenceExpression)) {
                this.checkUnused((JSNamedElement)node);
            }
        }

        public void visitJSDefinitionExpression(JSDefinitionExpression node) {
            JSExpression expression = node.getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
                boolean doCheck = this.myReportUnusedDefinitions;
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)qualifier).getReferencedName())) {
                    doCheck = true;
                }
                if (!doCheck) {
                    return;
                }
                PsiElement parent = node.getParent();
                if (parent instanceof JSAssignmentExpression) {
                    PsiElement resolve;
                    JSReferenceExpression refExpr = (JSReferenceExpression)expression;
                    JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
                    if (rOperand != null && ((resolve = refExpr.resolve()) == node || resolve == rOperand)) {
                        this.checkUnused((JSNamedElement)node);
                    }
                }
            }
        }

        public void visitJSProperty(JSProperty node) {
            JSFunction value = node.tryGetFunctionInitializer();
            if (!this.myReportUnusedProperties && value == null) {
                return;
            }
            PsiElement nameIdentifier = node.getNameIdentifier();
            if (nameIdentifier == null || !StringUtil.isJavaIdentifier((String)nameIdentifier.getText())) {
                return;
            }
            PsiPolyVariantReference reference = node.getPropertyNameReference();
            if (reference != null) {
                ResolveResult[] results;
                for (ResolveResult result : results = reference.multiResolve(false)) {
                    if (!result.isValidResult() || result.getElement() == node) continue;
                    return;
                }
            }
            this.checkUnused((JSNamedElement)node);
        }

        protected void checkUnused(JSNamedElement namedElement) {
            Project project;
            GlobalSearchScope scopeForSearch;
            if (namedElement instanceof JSPackageStatement) {
                return;
            }
            if (namedElement instanceof JSFunction && !JSInheritanceUtil.iterateOverriddenMethodsUp((JSFunction)namedElement, (Processor<JSFunction>)CommonProcessors.alwaysFalse())) {
                return;
            }
            PsiElement elementParent = namedElement.getParent();
            if (JSResolveUtil.isConstructorFunction((PsiElement)namedElement) && elementParent instanceof JSFile && elementParent.getContext() != null) {
                return;
            }
            String name = namedElement.getName();
            if (name == null) {
                return;
            }
            if (JSUnusedLocalSymbolsInspection.isLocallyDefined(namedElement)) {
                return;
            }
            JSSharedUsageInformation sharedInfo = JSSharedUsageInformation.get(this.myFile);
            if (sharedInfo.isReferenced((PsiNamedElement)namedElement)) {
                return;
            }
            JSNamedElement elementToSearchUsages = namedElement;
            if (elementToSearchUsages instanceof JSFunction) {
                List implementedMethods;
                JSFunction topOverriddenMethod;
                JSFunction fun = (JSFunction)elementToSearchUsages;
                if ("toString".equals(name)) {
                    return;
                }
                if (name.length() < 3) {
                    return;
                }
                JSAttributeList attrList = fun.getAttributeList();
                if (attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && (topOverriddenMethod = JSInheritanceUtil.findTopOverriddenMethod(fun)) != null) {
                    elementToSearchUsages = topOverriddenMethod;
                }
                Collection<Object> collection = implementedMethods = fun.isConstructor() ? Collections.emptyList() : JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)elementToSearchUsages);
                if (!implementedMethods.isEmpty()) {
                    return;
                }
            }
            if ((scopeForSearch = MyJSElementVisitor.getScopeForSearch((PsiElement)elementToSearchUsages, project = namedElement.getProject())) == null) {
                return;
            }
            if (this.notCheap(namedElement.getContainingFile(), name, project, scopeForSearch)) {
                return;
            }
            boolean unused = JSUnusedGlobalSymbolsInspection.calcUnused((PsiElement)elementToSearchUsages, (SearchScope)scopeForSearch);
            if (unused) {
                if (namedElement instanceof JSClass) {
                    JSFunction constructor = ((JSClass)namedElement).getConstructor();
                    if (constructor != null) {
                        unused = JSUnusedGlobalSymbolsInspection.calcUnused((PsiElement)constructor, (PsiElement)namedElement, (SearchScope)scopeForSearch);
                    }
                } else if (JSResolveUtil.isConstructorFunction((PsiElement)namedElement) && elementParent instanceof JSClass) {
                    unused = JSUnusedGlobalSymbolsInspection.calcUnused((PsiElement)((JSClass)elementParent), (SearchScope)scopeForSearch);
                }
            }
            if (unused) {
                this.myConsumer.consume((Object)namedElement);
            }
        }

        private boolean notCheap(@NotNull PsiFile psiFile, @NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scopeForSearch) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "notCheap"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "notCheap"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "notCheap"));
            }
            if (scopeForSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForSearch", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor", "notCheap"));
            }
            PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.SERVICE.getInstance((Project)project).isCheapEnoughToSearch(name, scopeForSearch, psiFile, this.progress);
            return cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }

        @Nullable
        private static GlobalSearchScope getScopeForSearch(PsiElement elementToSearchUsages, Project project) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile file = elementToSearchUsages.getContainingFile().getVirtualFile();
            if (file == null || projectFileIndex.isInLibraryClasses(file) || projectFileIndex.isInLibrarySource(file) || JSLibraryUtil.isProbableLibraryFile(file, project)) {
                return null;
            }
            SearchScope scope = elementToSearchUsages.getUseScope();
            if (!(scope instanceof GlobalSearchScope)) {
                return null;
            }
            if (!GlobalSearchScope.allScope((Project)project).contains(file)) {
                return null;
            }
            return JSUnusedGlobalSymbolsInspection.skipLibraryFiles(project, (GlobalSearchScope)scope);
        }
    }
}

