/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertParametersToObjectIntention
extends JavaScriptIntention {
    private static final Logger LOGGER = Logger.getInstance(JSConvertParametersToObjectIntention.class);
    private static final String PARAMETERS_VARIABLE = "parameters";

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class);
        return parameterList != null && parameterList.getParameters().length > 0;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSFunction funcRef;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "invoke"));
        }
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class);
        if (parameterList == null) {
            return;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        while (JSPsiImplUtils.isTypeSignature(function)) {
            if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class)) == null) {
                HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.type.function", (Object[])new Object[0]));
                return;
            }
            parameterList = function.getParameterList();
        }
        if (parameterList == null) {
            HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.function.no.parameters", (Object[])new Object[0]));
            return;
        }
        if (JSPsiImplUtils.isArrowFunction(function) != null) {
            HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.arrow.function", (Object[])new Object[0]));
            return;
        }
        Object object = funcRef = function instanceof JSFunctionExpression ? JSPsiImplUtils.getInitializedElement((JSExpression)((JSFunctionExpression)function)) : function;
        if (function == null) {
            return;
        }
        JSParameter[] parameters = parameterList.getParameterVariables();
        if (parameters.length == 0) {
            return;
        }
        ArrayList<JSCallExpression> callExpressions = new ArrayList<JSCallExpression>();
        JSConvertParametersToObjectIntention.fillFunctionUsagesWithProgress(element, function, (JSNamedElement)funcRef, callExpressions);
        JSConvertParametersToObjectIntention.addVariablesInitializationToFunctionBody(project, element, parameters, function);
        JSConvertParametersToObjectIntention.replaceParametersInFunctionSignature(project, parameterList, parameters);
        JSConvertParametersToObjectIntention.replaceArgumentsInCalls(parameters, callExpressions);
    }

    private static void replaceArgumentsInCalls(@NotNull JSParameter[] parameters, @NotNull List<JSCallExpression> callExpressions) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PARAMETERS_VARIABLE, "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "replaceArgumentsInCalls"));
        }
        if (callExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpressions", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "replaceArgumentsInCalls"));
        }
        for (JSCallExpression call : callExpressions) {
            JSExpression[] arguments;
            int argToReplaceCount;
            JSArgumentList argumentList = call.getArgumentList();
            if (argumentList == null || (argToReplaceCount = Math.min((arguments = argumentList.getArguments()).length, parameters.length)) <= 0) continue;
            String newArgument = JSConvertParametersToObjectIntention.wrapArgumentsWithObjectLiteral(parameters, arguments, argToReplaceCount);
            if (argToReplaceCount > 1) {
                argumentList.getNode().removeRange(arguments[0].getNode(), arguments[argToReplaceCount - 1].getNode());
            }
            arguments[argToReplaceCount - 1].replace(JSChangeUtil.createExpressionWithContext(newArgument, (PsiElement)call).getPsi());
        }
    }

    private static void replaceParametersInFunctionSignature(@NotNull Project project, @NotNull JSParameterList parameterList, @NotNull JSParameter[] parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "replaceParametersInFunctionSignature"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "replaceParametersInFunctionSignature"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PARAMETERS_VARIABLE, "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "replaceParametersInFunctionSignature"));
        }
        String typeString = JSConvertParametersToObjectIntention.getNewParameterType(parameterList, parameters);
        JSParameter firstParam = parameters[0];
        JSParameter lastParam = parameters[parameters.length - 1];
        if (parameters.length > 1) {
            parameterList.getNode().removeRange(firstParam.getNode(), lastParam.getNode());
        }
        String templateFunctionText = "function f(parameters" + typeString + ") {}";
        ASTNode text = JSChangeUtil.createStatementFromTextWithContext(project, templateFunctionText, (PsiElement)parameterList.getContainingFile());
        assert (text != null);
        JSFunction templateFunction = (JSFunction)text.getPsi();
        JSParameterList list = templateFunction.getParameterList();
        assert (list != null);
        lastParam.replace((PsiElement)list.getParameters()[0]);
    }

    @Nullable
    private static String getNewParameterType(@NotNull JSParameterList parameterList, @NotNull JSParameter[] parameters) {
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "getNewParameterType"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PARAMETERS_VARIABLE, "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "getNewParameterType"));
        }
        String newCompositeParameterType = null;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)parameterList);
        if (holder != null && holder.isTypeScript) {
            newCompositeParameterType = StringUtil.join((Object[])parameters, parameter -> {
                if (parameterList == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "lambda$getNewParameterType$0"));
                }
                JSType type = parameter.getType();
                String name = parameter.getName();
                return name + ": " + (type != null ? type.getTypeText(JSType.TypeTextFormat.CODE) : JSClassUtils.getAnyTypeString((PsiElement)parameterList, true));
            }, (String)", ");
        }
        return StringUtil.isEmpty(newCompositeParameterType) ? "" : ": { " + newCompositeParameterType + " }";
    }

    private static void fillFunctionUsagesWithProgress(@NotNull PsiElement invocationElement, @NotNull JSFunction function, @Nullable JSNamedElement funcRef, @NotNull List<JSCallExpression> callExpressions) {
        PsiElement funcGrandParent;
        if (invocationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocationElement", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "fillFunctionUsagesWithProgress"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "fillFunctionUsagesWithProgress"));
        }
        if (callExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpressions", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "fillFunctionUsagesWithProgress"));
        }
        PsiElement funcParent = function.getParent();
        if (funcParent instanceof JSCallExpression) {
            callExpressions.add((JSCallExpression)funcParent);
        }
        if (funcParent instanceof JSParenthesizedExpression && (funcGrandParent = funcParent.getParent()) instanceof JSCallExpression) {
            callExpressions.add((JSCallExpression)funcGrandParent);
        }
        if (funcRef != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (callExpressions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpressions", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "lambda$fillFunctionUsagesWithProgress$1"));
                }
                for (PsiReference reference : ReferencesSearch.search((PsiElement)funcRef).findAll()) {
                    PsiElement referenceElement = reference.getElement();
                    PsiElement parent = referenceElement.getParent();
                    if (!(parent instanceof JSCallExpression)) continue;
                    callExpressions.add((JSCallExpression)parent);
                }
            }, "Find Usages", false, invocationElement.getProject());
        }
    }

    @NotNull
    private static String wrapArgumentsWithObjectLiteral(@NotNull JSParameter[] parameters, @NotNull JSExpression[] arguments, int argToReplaceCount) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PARAMETERS_VARIABLE, "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "wrapArgumentsWithObjectLiteral"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "wrapArgumentsWithObjectLiteral"));
        }
        StringBuilder builder = new StringBuilder(argToReplaceCount * 4);
        builder.append("{");
        for (int i = 0; i < argToReplaceCount; ++i) {
            builder.append(parameters[i].getName());
            builder.append(" : ");
            builder.append(arguments[i].getText());
            if (i >= argToReplaceCount - 1) continue;
            builder.append(", ");
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "wrapArgumentsWithObjectLiteral"));
        }
        return string;
    }

    private static void addVariablesInitializationToFunctionBody(@NotNull Project project, @NotNull PsiElement context, @NotNull JSParameter[] parameters, @NotNull JSFunction function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "addVariablesInitializationToFunctionBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "addVariablesInitializationToFunctionBody"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PARAMETERS_VARIABLE, "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "addVariablesInitializationToFunctionBody"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention", "addVariablesInitializationToFunctionBody"));
        }
        JSBlockStatement body = (JSBlockStatement)function.getBody()[0];
        PsiElement anchor = body.getFirstChild();
        String variablePrefix = JSChangeUtil.getVariablePrefix(context);
        String semicolon = JSCodeStyleSettings.getSemicolon(function.getContainingFile());
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && holder.hasFeature(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT) && parameters.length > 1) {
            String joinedParameters = StringUtil.join((Object[])parameters, parameter -> parameter.getName(), (String)", ");
            String variableText = variablePrefix + " { " + joinedParameters + " } = " + PARAMETERS_VARIABLE + semicolon;
            ASTNode decl = JSChangeUtil.createStatementFromTextWithContext(project, variableText, context);
            body.addAfter(decl.getPsi(), anchor);
        } else {
            for (JSParameter parameter2 : parameters) {
                String parameterName = parameter2.getName();
                String variableText = variablePrefix + " " + parameterName + " = " + PARAMETERS_VARIABLE + "." + parameterName + semicolon;
                ASTNode decl = JSChangeUtil.createStatementFromTextWithContext(project, variableText, context);
                if (decl == null) {
                    LOGGER.error("Cannot parse statement " + variableText);
                    return;
                }
                anchor = body.addAfter(decl.getPsi(), anchor);
            }
        }
    }
}

