/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceIncludingLocalMembersIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSFunctionToES6ClassIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public boolean myGenerateTheWholeTree = false;

    public JSFunctionToES6ClassIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.es6.class", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.isES6(element) && !DialectDetector.isJSX(element)) {
            return false;
        }
        JSFunction function = JSFunctionToES6ClassIntention.getWrappingFunction(element);
        return function != null && function.getName() != null && JSFunctionToES6ClassIntention.checkContext(function);
    }

    private static boolean checkContext(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "checkContext"));
        }
        if (function.getParent() instanceof JSClass) {
            return false;
        }
        if (function.getParent() instanceof TypeScriptObjectType && function.getParent().getParent() instanceof JSClass) {
            return false;
        }
        return JSFunctionToES6ClassIntention.hasPrototypeAssignment(function);
    }

    private static boolean hasPrototypeAssignment(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "hasPrototypeAssignment"));
        }
        String name = function.getQualifiedName() == null ? function.getName() : function.getQualifiedName();
        return !JSClassResolver.getInstance().processNamespaceMembers(name, JSResolveUtil.getResolveScope((PsiElement)function), (Processor<JSPsiElementBase>)((Processor)base -> {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "lambda$hasPrototypeAssignment$0"));
            }
            return base.equals(function) || !JSContext.INSTANCE.equals((Object)base.getJSContext()) && !JSContext.STATIC.equals((Object)base.getJSContext());
        }), JSNamespaceIncludingLocalMembersIndex.KEY);
    }

    public static JSFunction getWrappingFunction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "getWrappingFunction"));
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile) && PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class) == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunction) {
            return (JSFunction)parent;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getInitializer() instanceof JSFunction) {
            return (JSFunction)((JSVariable)parent).getInitializer();
        }
        while (parent instanceof JSReferenceExpression || parent instanceof JSDefinitionExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getDefinitionExpression() != null && ((JSAssignmentExpression)parent).getDefinitionExpression().getInitializer() instanceof JSFunction) {
            return (JSFunction)((JSAssignmentExpression)parent).getDefinitionExpression().getInitializer();
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "invoke"));
        }
        JSFunction function = JSFunctionToES6ClassIntention.getWrappingFunction(element);
        if (function == null || function.getName() == null || !JSFunctionToES6ClassIntention.checkContext(function)) {
            return;
        }
        JSConvertToClassProcessor processor = new JSConvertToClassProcessor(project, EmptyRunnable.getInstance(), function);
        if (this.myGenerateTheWholeTree) {
            processor.generateTheWholeTree();
        }
        processor.run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.es6.class.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSFunctionToES6ClassIntention", "getFamilyName"));
        }
        return string;
    }
}

