/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringInjectionsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.NotNull;

public abstract class JSStringTemplateConvertVisibilityOfLineSeparatorsIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    protected abstract boolean isAvailableForSeparatorsCheckResult(@NotNull SeparatorsChecker var1);

    protected abstract Convertor<String, String> createConvertor();

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "invoke"));
        }
        JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.convert(project, element, this.createConvertor());
    }

    public static void convert(@NotNull Project project, @NotNull PsiElement element, @NotNull Convertor<String, String> convertor) {
        JSStringTemplateExpression stringTemplateExpression;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "convert"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "convert"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "convert"));
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return;
        }
        if ((element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) && (stringTemplateExpression = JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.getStringTemplate(element)) != null) {
            String result = new NonInterpolationFragments(stringTemplateExpression.getText(), convertor).getResult();
            stringTemplateExpression.replace(JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.createReplacement(project, result, DialectDetector.languageDialectOfElement(element)));
        }
    }

    private static JSStringTemplateExpression getStringTemplate(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "getStringTemplate"));
        }
        return element instanceof JSStringTemplateExpression ? (JSStringTemplateExpression)element : (JSStringTemplateExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSStringTemplateExpression.class);
    }

    private static PsiElement createReplacement(@NotNull Project project, @NotNull String text, JSLanguageDialect dialect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "createReplacement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "createReplacement"));
        }
        JSVarStatement statement = (JSVarStatement)JSChangeUtil.createStatementFromText(project, "var me = " + text + ";", dialect).getPsi(JSVarStatement.class);
        return statement.getVariables()[0].getInitializer();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSStringTemplateExpression stringTemplateExpression;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        if ((element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) && (stringTemplateExpression = JSStringTemplateConvertVisibilityOfLineSeparatorsIntention.getStringTemplate(element)) != null) {
            return this.isAvailableForSeparatorsCheckResult(new SeparatorsChecker(stringTemplateExpression.getText()));
        }
        return false;
    }

    private static class NonInterpolationFragments
    extends StringInjectionsProcessor {
        private final StringBuilder mySb;
        @NotNull
        private final Convertor<String, String> myConvertor;

        public NonInterpolationFragments(@NotNull String text, @NotNull Convertor<String, String> convertor) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$NonInterpolationFragments", "<init>"));
            }
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$NonInterpolationFragments", "<init>"));
            }
            super("${", "}", text);
            this.myConvertor = convertor;
            this.mySb = new StringBuilder();
            this.process();
        }

        protected boolean onText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$NonInterpolationFragments", "onText"));
            }
            this.mySb.append((String)this.myConvertor.convert((Object)text));
            return true;
        }

        protected boolean onInjection(@NotNull String injection) {
            if (injection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$NonInterpolationFragments", "onInjection"));
            }
            this.mySb.append(injection);
            return true;
        }

        public String getResult() {
            return this.mySb.toString();
        }
    }

    protected static class SeparatorsChecker
    extends StringInjectionsProcessor {
        private boolean myHaveVisible;
        private boolean myHaveInvisible;

        public SeparatorsChecker(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$SeparatorsChecker", "<init>"));
            }
            super("${", "}", text);
            this.process();
        }

        protected boolean onText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$SeparatorsChecker", "onText"));
            }
            this.myHaveInvisible = text.contains("\n");
            this.myHaveVisible = text.contains("\\n");
            return !this.myHaveInvisible || !this.myHaveVisible;
        }

        protected boolean onInjection(@NotNull String injection) {
            if (injection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "com/intellij/lang/javascript/intentions/JSStringTemplateConvertVisibilityOfLineSeparatorsIntention$SeparatorsChecker", "onInjection"));
            }
            return true;
        }

        public boolean isHaveVisible() {
            return this.myHaveVisible;
        }

        public boolean isHaveInvisible() {
            return this.myHaveInvisible;
        }
    }
}

