/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.lang.ecmascript6.intentions.ES6ReplaceImportFromClauseFix;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptChangeES6ImportIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @Nullable
    public static TypeScriptChangeES6ImportIntention create(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "create"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        Collection psiElements = clause.resolveReferencedElements();
        if (psiElements.size() != 1 || !(ContainerUtil.getFirstItem((Collection)psiElements) instanceof JSFile)) {
            return null;
        }
        return new TypeScriptChangeES6ImportIntention();
    }

    @NotNull
    public static List<TypeScriptAutoImportUtil.ModuleInfo> getModuleInfos(@NotNull ES6ImportDeclaration declaration, @NotNull ES6FromClause clause, Collection<JSQualifiedNamedElement> elements, boolean stopIfMoreThanOne) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "getModuleInfos"));
        }
        if (clause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "getModuleInfos"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSQualifiedNamedElement firstItem = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(elements);
        if (firstItem == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "getModuleInfos"));
            }
            return list;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        HashMap checkedFiles = ContainerUtil.newHashMap();
        Processor processor = info -> {
            if (clause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "lambda$getModuleInfos$0"));
            }
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "lambda$getModuleInfos$0"));
            }
            if (!info.isValid()) {
                return true;
            }
            if (StringUtil.equals((CharSequence)clause.getReferenceText(), (CharSequence)info.getPath())) {
                return true;
            }
            boolean allIncluded = true;
            VirtualFile module = info.getModule();
            Boolean value = (Boolean)checkedFiles.get(module);
            if (value == null) {
                for (JSQualifiedNamedElement element : elements) {
                    if (element == firstItem) continue;
                    assert (module != null);
                    if (TypeScriptAutoImportUtil.checkSymbolInFile(element.getProject(), module, element, declaration.getContainingFile())) continue;
                    allIncluded = false;
                }
                checkedFiles.put(module, allIncluded);
            } else if (Boolean.FALSE.equals(value)) {
                return true;
            }
            if (allIncluded) {
                infos.add(info);
            }
            return !stopIfMoreThanOne || infos.size() <= 1;
        };
        TypeScriptAutoImportUtil.processExternalFileModuleNames(declaration.getProject(), firstItem, firstItem.getContainingFile(), (PsiElement)declaration, (Processor<TypeScriptAutoImportUtil.ModuleInfo>)processor);
        ArrayList arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "getModuleInfos"));
        }
        return arrayList;
    }

    private static Collection<JSQualifiedNamedElement> getResolvedElements(@NotNull ES6ImportDeclaration declaration) {
        ES6ImportedBinding[] bindings;
        ES6ImportSpecifier[] specifiers;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "getResolvedElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet resolvedElements = ContainerUtil.newHashSet();
        for (ES6ImportSpecifier specifier : specifiers = declaration.getImportSpecifiers()) {
            ResolveResult[] results;
            for (ResolveResult result : results = specifier.multiResolve(false)) {
                PsiElement element;
                if (!result.isValidResult() || !((element = result.getElement()) instanceof JSQualifiedNamedElement)) continue;
                resolvedElements.add((JSQualifiedNamedElement)element);
            }
        }
        for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
            Collection elements = binding.findReferencedElements().stream().filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).collect(Collectors.toList());
            resolvedElements.addAll(elements);
        }
        return resolvedElements;
    }

    public TypeScriptChangeES6ImportIntention() {
        this.setText(JSBundle.message((String)"ts.change.import.action.many.title", (Object[])new Object[0]));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "invoke"));
        }
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class);
        if (importDeclaration == null) {
            return;
        }
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptChangeES6ImportIntention.getResolvedElements(importDeclaration);
        List<TypeScriptAutoImportUtil.ModuleInfo> infos = TypeScriptChangeES6ImportIntention.getModuleInfos(importDeclaration, clause, elements, false);
        if (infos.isEmpty() && infos.size() > 1) {
            return;
        }
        if (infos.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            TypeScriptAutoImportUtil.ModuleInfo info = infos.get(0);
            WriteAction.run(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "lambda$invoke$3"));
                }
                ES6ReplaceImportFromClauseFix.changeImportFromText(project, clause, info.getModuleName());
            });
        } else {
            JBList list = new JBList(infos);
            list.setFont(EditorUtil.getEditorFont());
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
            builder.setTitle(JSBundle.message((String)"ts.change.import.action.dialog.title", (Object[])new Object[0]));
            JBPopup popup = builder.setItemChoosenCallback(() -> TypeScriptChangeES6ImportIntention.lambda$invoke$6((JList)list, project, clause)).createPopup();
            builder.getScrollPane().setBorder(null);
            builder.getScrollPane().setViewportBorder(null);
            NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
            popup.showInBestPositionFor(editor);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class);
        if (importDeclaration == null) {
            return false;
        }
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return false;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptChangeES6ImportIntention.getResolvedElements(importDeclaration);
        List<TypeScriptAutoImportUtil.ModuleInfo> infos = TypeScriptChangeES6ImportIntention.getModuleInfos(importDeclaration, clause, elements, true);
        if (infos.size() == 0) {
            return false;
        }
        if (infos.size() == 1) {
            this.setText(JSBundle.message((String)"ts.change.import.action.one.title", (Object[])new Object[]{infos.get(0).toString()}));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$invoke$6(JList list, @NotNull Project project, ES6FromClause clause) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "lambda$invoke$6"));
        }
        TypeScriptAutoImportUtil.ModuleInfo info = (TypeScriptAutoImportUtil.ModuleInfo)list.getSelectedValue();
        if (info != null) {
            Runnable toRun = () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "lambda$null$5"));
                }
                WriteAction.run(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptChangeES6ImportIntention", "lambda$null$4"));
                    }
                    ES6ReplaceImportFromClauseFix.changeImportFromText(project, clause, info.getModuleName());
                });
            };
            CommandProcessor.getInstance().executeCommand(project, toRun, JSBundle.message((String)"ts.change.import.action.command", (Object[])new Object[0]), null);
        }
    }
}

