/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.json.JSJsonPropertyAdapter;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.impl.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import com.jetbrains.jsonSchema.impl.JsonValueAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonLikePsiWalker
implements JsonLikePsiWalker {
    private final boolean myTopLevelArraysAllowed;

    public JSJsonLikePsiWalker(boolean allowed) {
        this.myTopLevelArraysAllowed = allowed;
    }

    public boolean handles(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "handles"));
        }
        return element instanceof JSElement || element instanceof LeafPsiElement && element.getParent() instanceof JSElement;
    }

    public boolean isName(PsiElement checkable) {
        PsiElement parent = checkable.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            return true;
        }
        if (parent instanceof JSProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JSProperty)parent).getNameIdentifier(), (PsiElement)checkable, (boolean)false);
        }
        return false;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "isPropertyWithValue"));
        }
        return element instanceof JSProperty && ((JSProperty)element).getValue() != null;
    }

    public PsiElement goUpToCheckable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "goUpToCheckable"));
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (!(current instanceof JSExpression) && !(current instanceof JSProperty)) continue;
            return current;
        }
        return null;
    }

    public List<JsonSchemaWalker.Step> findPosition(@NotNull PsiElement element, boolean isName, boolean forceLastTransition) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "findPosition"));
        }
        ArrayList<JsonSchemaWalker.Step> steps = new ArrayList<JsonSchemaWalker.Step>();
        if (!isName) {
            steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._value, null));
        }
        PsiElement previous = null;
        PsiElement current = element;
        while (!this.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            previous = current;
            if ((current = current.getParent()) instanceof JSArrayLiteralExpression) {
                JSArrayLiteralExpression array = (JSArrayLiteralExpression)current;
                JSExpression[] expressions = array.getExpressions();
                int idx = -1;
                for (int i = 0; i < expressions.length; ++i) {
                    JSExpression value = expressions[i];
                    if (!value.equals(position)) continue;
                    idx = i;
                    break;
                }
                steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._array, (JsonSchemaWalker.Transition)new JsonSchemaWalker.ArrayTransition(idx)));
                continue;
            }
            if (current instanceof JSProperty) {
                propertyName = StringUtil.notNullize((String)((JSProperty)current).getName());
                previous = current;
                if (!((current = current.getParent()) instanceof JSObjectLiteralExpression)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._object, (JsonSchemaWalker.Transition)new JsonSchemaWalker.PropertyTransition(propertyName)));
                continue;
            }
            if (current instanceof JSObjectLiteralExpression && position instanceof JSProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = StringUtil.notNullize((String)((JSProperty)position).getName());
                steps.add(new JsonSchemaWalker.Step(JsonSchemaWalker.StateType._object, (JsonSchemaWalker.Transition)new JsonSchemaWalker.PropertyTransition(propertyName)));
                continue;
            }
            if (this.breakCondition(current)) break;
            return null;
        }
        Collections.reverse(steps);
        return JSJsonLikePsiWalker.checkImmediateParent(previous, current) ? this.filterArray(steps) : null;
    }

    private List<JsonSchemaWalker.Step> filterArray(List<JsonSchemaWalker.Step> steps) {
        if (steps.isEmpty()) {
            return steps;
        }
        if (!this.myTopLevelArraysAllowed && JsonSchemaWalker.StateType._array.equals((Object)steps.get(0).getType())) {
            return steps.subList(1, steps.size());
        }
        return steps;
    }

    public boolean isNameQuoted() {
        return false;
    }

    public boolean onlyDoubleQuotesForStringLiterals() {
        return false;
    }

    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "hasPropertiesBehindAndNoComma"));
        }
        PsiElement psiElement = current = element instanceof JSProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class);
        while (current != null && current.getNode().getElementType() != JSTokenTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JSObjectLiteralExpression object = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSObjectLiteralExpression.class);
        if (object != null) {
            for (JSProperty property : object.getProperties()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "getPropertyNamesOfParentObject"));
        }
        JSObjectLiteralExpression object = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSObjectLiteralExpression.class);
        if (object != null) {
            return Arrays.stream(object.getProperties()).filter(p -> p != null && p.getName() != null).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "getParentPropertyAdapter"));
        }
        JSProperty property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class, (boolean)false);
        return property == null ? null : new JSJsonPropertyAdapter(property);
    }

    private boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof JSEmbeddedContent || JSJsonLikePsiWalker.isTerminalInStatement(current) || !this.myTopLevelArraysAllowed && current instanceof JSArrayLiteralExpression && JSJsonLikePsiWalker.isTerminalInStatement(current.getParent());
    }

    static boolean isTerminalInStatement(PsiElement current) {
        return current instanceof JSStatement || current instanceof JSArgumentList || current instanceof JSVariable || current instanceof JSAssignmentExpression && (current.getParent() instanceof JSStatement || current instanceof JSCommaExpression);
    }

    private static boolean checkImmediateParent(PsiElement top, PsiElement parent) {
        return true;
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "isTopJsonElement"));
        }
        return this.breakCondition(element);
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JSJsonLikePsiWalker", "createValueAdapter"));
        }
        return element instanceof JSExpression ? JSJsonPropertyAdapter.createValueAdapterByType((JSExpression)element) : null;
    }
}

