/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.lang.javascript.json.JSJsonPropertyAdapter;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonPropertyAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonObjectAdapter
implements JsonObjectValueAdapter {
    @NotNull
    private final JSObjectLiteralExpression myObject;

    public JSJsonObjectAdapter(@NotNull JSObjectLiteralExpression object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/json/JSJsonObjectAdapter", "<init>"));
        }
        this.myObject = object;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        JSObjectLiteralExpression jSObjectLiteralExpression = this.myObject;
        if (jSObjectLiteralExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/JSJsonObjectAdapter", "getDelegate"));
        }
        return jSObjectLiteralExpression;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return this;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return false;
    }

    @NotNull
    public List<JsonPropertyAdapter> getPropertyList() {
        List<JsonPropertyAdapter> list = Arrays.stream(this.myObject.getProperties()).filter(p -> p != null).map(p -> new JSJsonPropertyAdapter((JSProperty)p)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/JSJsonObjectAdapter", "getPropertyList"));
        }
        return list;
    }
}

