/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDownloadManager {
    private ProgressIndicator myProgress;
    private final String myTestRoot;
    private final String myTargetDirPath;
    private JSDownloadException myLastException;
    private String myActualSource;
    private String myTargetFilePath;

    public JSDownloadManager(@Nullable String testRoot) {
        this.myTestRoot = testRoot;
        this.myTargetDirPath = JSDownloadManager.getTargetDirPath();
        this.myLastException = null;
    }

    public static String getTargetDirPath() {
        return JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "extLibs";
    }

    public void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.myProgress = progressIndicator;
    }

    @Nullable
    public String download(@NotNull String location, @NotNull String extension) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/library/download/JSDownloadManager", "download"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/lang/javascript/library/download/JSDownloadManager", "download"));
        }
        this.myActualSource = JSLibraryUtil.getDevVersionLocation(location);
        String targetFileName = JSLibraryUtil.makeUniqueFileName(this.myActualSource, true) + extension;
        this.myLastException = null;
        try {
            return this.fetch(this.myActualSource, targetFileName);
        }
        catch (JSDownloadException e) {
            if (e.getCause() instanceof IOException) {
                try {
                    this.myActualSource = location;
                    targetFileName = JSLibraryUtil.makeUniqueFileName(this.myActualSource, false) + extension;
                    return this.fetch(this.myActualSource, targetFileName);
                }
                catch (JSDownloadException e1) {
                    this.myLastException = e1;
                }
            } else {
                this.myLastException = e;
            }
            return null;
        }
    }

    public String getActualSource() {
        return this.myActualSource;
    }

    @Nullable
    public JSDownloadException getLastException() {
        return this.myLastException;
    }

    @NotNull
    private String fetch(String location, String targetFileName) throws JSDownloadException {
        String string;
        File targetDir = new File(this.myTargetDirPath);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new JSDownloadException("Can not create " + this.myTargetDirPath + " directory.");
        }
        if (location.startsWith("//")) {
            location = "http:" + location;
        }
        String targetPath = this.myTargetDirPath + File.separatorChar + targetFileName;
        File targetFile = new File(targetPath);
        try {
            if (this.myTestRoot == null) {
                DownloadUtil.downloadAtomically((ProgressIndicator)this.myProgress, (String)location, (File)targetFile);
            } else {
                File f = new File(location.replaceFirst("^(http|https)://", this.myTestRoot + "/"));
                FileUtil.copy((File)f, (File)targetFile);
            }
            this.myTargetFilePath = targetPath;
            string = targetPath;
        }
        catch (IOException e) {
            if (targetFile.exists()) {
                FileUtil.delete((File)targetFile);
            }
            throw new JSDownloadException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager", "fetch"));
        }
        return string;
    }

    public String getTargetFilePath() {
        return this.myTargetFilePath;
    }

    public static class JSDownloadException
    extends Exception {
        public JSDownloadException(String message) {
            super(message);
        }

        public JSDownloadException(Throwable e) {
            super(e);
        }

        @NotNull
        public String getReason() {
            Throwable t = this.getCause();
            if (t == null) {
                String string = StringUtil.notNullize((String)this.getMessage());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager$JSDownloadException", "getReason"));
                }
                return string;
            }
            if (t instanceof FileNotFoundException) {
                if ("File not found" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager$JSDownloadException", "getReason"));
                }
                return "File not found";
            }
            if (t instanceof UnknownHostException) {
                if ("Unknown host" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager$JSDownloadException", "getReason"));
                }
                return "Unknown host";
            }
            String string = StringUtil.notNullize((String)t.getMessage());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager$JSDownloadException", "getReason"));
            }
            return string;
        }
    }
}

