/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterFileLevelAnnotation {
    private Icon myIcon;
    @Nullable
    private String myShortMessage;
    private String myMessage;
    private final HighlightSeverity mySeverity;
    private final JSLinterStandardFixes myFixes;

    public JSLinterFileLevelAnnotation(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "<init>"));
        }
        this(null, message, HighlightSeverity.ERROR, JSLinterStandardFixes.DEFAULT);
    }

    public JSLinterFileLevelAnnotation(@NotNull String message, @Nullable IntentionAction showDetails) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "<init>"));
        }
        this(null, message, HighlightSeverity.ERROR, new JSLinterStandardFixes().setDetailsAction(showDetails));
    }

    public JSLinterFileLevelAnnotation(@Nullable Icon icon, @NotNull String message, @NotNull HighlightSeverity severity, @NotNull JSLinterStandardFixes fixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "<init>"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "<init>"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "<init>"));
        }
        this.myIcon = icon;
        this.myMessage = message;
        this.mySeverity = severity;
        this.myFixes = fixes;
    }

    public JSLinterFileLevelAnnotation(@NotNull JSLinterFileLevelAnnotation copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "<init>"));
        }
        this.myIcon = copy.myIcon;
        this.myMessage = copy.myMessage;
        this.myShortMessage = copy.myShortMessage;
        this.mySeverity = copy.mySeverity;
        this.myFixes = copy.myFixes.copy();
    }

    public JSLinterFileLevelAnnotation withIcon(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "withIcon"));
        }
        this.myIcon = icon;
        return this;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "getMessage"));
        }
        return string;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "getSeverity"));
        }
        return highlightSeverity;
    }

    @NotNull
    public JSLinterStandardFixes getFixes() {
        JSLinterStandardFixes jSLinterStandardFixes = this.myFixes;
        if (jSLinterStandardFixes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "getFixes"));
        }
        return jSLinterStandardFixes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLinterFileLevelAnnotation that = (JSLinterFileLevelAnnotation)o;
        return !(this.myMessage != null ? !this.myMessage.equals(that.myMessage) : that.myMessage != null);
    }

    public int hashCode() {
        return this.myMessage != null ? this.myMessage.hashCode() : 0;
    }

    public void prefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation", "prefix"));
        }
        this.myMessage = prefix + this.myMessage;
        if (this.myShortMessage != null) {
            this.myShortMessage = prefix + this.myShortMessage;
        }
    }

    @Nullable
    public String getShortMessage() {
        return this.myShortMessage;
    }

    public void setShortMessage(@Nullable String shortMessage) {
        this.myShortMessage = shortMessage;
    }
}

