/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.PathHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.util.containers.BidirectionalMap;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class SharedConfigurationPaths {
    private final Logger LOG = Logger.getInstance(SharedConfigurationPaths.class);
    private final Project myProject;
    private final BidirectionalMap<VirtualFile, PathHolderImpl> myPaths;
    private final BidirectionalMap<String, PathHolderImpl> myNotExisting;
    private final Object myLock;

    public static SharedConfigurationPaths getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/SharedConfigurationPaths", "getInstance"));
        }
        return (SharedConfigurationPaths)ServiceManager.getService((Project)project, SharedConfigurationPaths.class);
    }

    public SharedConfigurationPaths(Project project) {
        this.myProject = project;
        this.myLock = new Object();
        this.myPaths = new BidirectionalMap();
        this.myNotExisting = new BidirectionalMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PathHolderImpl remove(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/SharedConfigurationPaths", "remove"));
        }
        Object object = this.myLock;
        synchronized (object) {
            PathHolderImpl holder = (PathHolderImpl)this.myPaths.remove((Object)file);
            if (holder != null) {
                return holder;
            }
            return (PathHolderImpl)this.myNotExisting.remove((Object)FileUtil.toSystemIndependentName((String)file.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(@NotNull VirtualFile file, PathHolderImpl holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/SharedConfigurationPaths", "add"));
        }
        String name = FileUtil.toSystemIndependentName((String)file.getPath());
        Object object = this.myLock;
        synchronized (object) {
            this.myNotExisting.remove((Object)name);
            this.myPaths.put((Object)file, (Object)holder);
        }
        holder.rename(name);
    }

    public PathHolder createPathHolder(Runnable saver) {
        return new PathHolderImpl(saver);
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/SharedConfigurationPaths$MyVirtualFileListener", "fileCreated"));
            }
            VirtualFile file = event.getFile();
            String key = FileUtil.toSystemIndependentName((String)file.getPath());
            Object object = SharedConfigurationPaths.this.myLock;
            synchronized (object) {
                PathHolderImpl pathHolder = (PathHolderImpl)SharedConfigurationPaths.this.myNotExisting.remove((Object)key);
                if (pathHolder != null) {
                    SharedConfigurationPaths.this.myPaths.put((Object)file, (Object)pathHolder);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/SharedConfigurationPaths$MyVirtualFileListener", "beforeFileDeletion"));
            }
            VirtualFile file = event.getFile();
            Object object = SharedConfigurationPaths.this.myLock;
            synchronized (object) {
                PathHolderImpl holder = (PathHolderImpl)SharedConfigurationPaths.this.myPaths.remove((Object)file);
                if (holder != null) {
                    SharedConfigurationPaths.this.myNotExisting.put((Object)FileUtil.toSystemIndependentName((String)file.getPath()), (Object)holder);
                }
            }
        }
    }

    public class PathHolderImpl
    implements PathHolder {
        private final Runnable mySaver;
        private final AtomicReference<String> myPath;

        public PathHolderImpl(Runnable saver) {
            this.mySaver = saver;
            this.myPath = new AtomicReference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/SharedConfigurationPaths$PathHolderImpl", "setPath"));
            }
            if (Comparing.equal((String)this.myPath.get(), (String)path)) {
                return;
            }
            this.myPath.set(path);
            File file = new File(path);
            file = file.isAbsolute() ? file : new File(SharedConfigurationPaths.this.myProject.getBasePath(), path);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            Object object = SharedConfigurationPaths.this.myLock;
            synchronized (object) {
                SharedConfigurationPaths.this.myPaths.removeValue((Object)this);
                SharedConfigurationPaths.this.myNotExisting.removeValue((Object)this);
                if (virtualFile != null) {
                    SharedConfigurationPaths.this.myPaths.put((Object)virtualFile, (Object)this);
                } else {
                    String independentName = FileUtil.toSystemIndependentName((String)path);
                    SharedConfigurationPaths.this.myNotExisting.put((Object)independentName, (Object)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rename(@NotNull String newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/lang/javascript/linter/SharedConfigurationPaths$PathHolderImpl", "rename"));
            }
            Object object = SharedConfigurationPaths.this.myLock;
            synchronized (object) {
                this.myPath.set(FileUtil.toSystemDependentName((String)newValue));
            }
            this.mySaver.run();
        }

        @Override
        public String getPath() {
            return this.myPath.get();
        }
    }
}

