/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EslintCheckstyleProblems {
    private static final Logger LOG = Logger.getInstance(EslintCheckstyleProblems.class);
    public static final String CANNOT_PARSE_ESLINT_XML_OUTPUT = "Cannot parse ESLint XML output: ";
    private final String myFailMessage;
    private final List<JSLinterError> myErrors;

    public EslintCheckstyleProblems(@Nullable String failMessage, @NotNull List<JSLinterError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "<init>"));
        }
        if (failMessage != null && !errors.isEmpty()) {
            throw new AssertionError((Object)"both failMessage and errors are non-empty");
        }
        this.myFailMessage = failMessage;
        this.myErrors = errors;
    }

    @Nullable
    public String getFailMessage() {
        return this.myFailMessage;
    }

    @NotNull
    public List<JSLinterError> getErrors() {
        List<JSLinterError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "getErrors"));
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EslintCheckstyleProblems problems = (EslintCheckstyleProblems)o;
        return ComparatorUtil.equalsNullable((Object)this.myFailMessage, (Object)problems.myFailMessage) && this.myErrors.equals(problems.myErrors);
    }

    public int hashCode() {
        int result = this.myFailMessage != null ? this.myFailMessage.hashCode() : 0;
        result = 31 * result + this.myErrors.hashCode();
        return result;
    }

    public String toString() {
        return "{failMessage='" + this.myFailMessage + '\'' + ", errors=" + this.myErrors + '}';
    }

    @NotNull
    public static EslintCheckstyleProblems parse(@NotNull String xml, boolean oneBasedColumn) {
        EslintCheckstyleProblems eslintCheckstyleProblems;
        block11: {
            SAXParser saxParser;
            if (xml == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "parse"));
            }
            String extracted = EslintCheckstyleProblems.extractXml(xml);
            if (extracted == null) {
                EslintCheckstyleProblems eslintCheckstyleProblems2 = EslintCheckstyleProblems.fail(xml);
                if (eslintCheckstyleProblems2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "parse"));
                }
                return eslintCheckstyleProblems2;
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(false);
            spf.setValidating(false);
            spf.setXIncludeAware(false);
            try {
                saxParser = spf.newSAXParser();
            }
            catch (Exception e) {
                LOG.warn("Cannot create SAX parser", (Throwable)e);
                EslintCheckstyleProblems eslintCheckstyleProblems3 = EslintCheckstyleProblems.fail("Cannot create SAX parser: " + e.getMessage());
                if (eslintCheckstyleProblems3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "parse"));
                }
                return eslintCheckstyleProblems3;
            }
            try {
                XMLReader xmlReader = saxParser.getXMLReader();
                EslintContentHandler handler = new EslintContentHandler(oneBasedColumn);
                xmlReader.setContentHandler(handler);
                xmlReader.parse(new InputSource(new StringReader(extracted)));
                eslintCheckstyleProblems = new EslintCheckstyleProblems(null, handler.myErrors);
                if (eslintCheckstyleProblems != null) break block11;
            }
            catch (SAXException e) {
                LOG.warn(CANNOT_PARSE_ESLINT_XML_OUTPUT + xml, (Throwable)e);
                EslintCheckstyleProblems eslintCheckstyleProblems4 = EslintCheckstyleProblems.fail(CANNOT_PARSE_ESLINT_XML_OUTPUT + xml);
                if (eslintCheckstyleProblems4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "parse"));
                }
                return eslintCheckstyleProblems4;
            }
            catch (IOException e) {
                LOG.warn(CANNOT_PARSE_ESLINT_XML_OUTPUT + xml, (Throwable)e);
                EslintCheckstyleProblems eslintCheckstyleProblems5 = EslintCheckstyleProblems.fail(CANNOT_PARSE_ESLINT_XML_OUTPUT + e.getMessage());
                if (eslintCheckstyleProblems5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "parse"));
                }
                return eslintCheckstyleProblems5;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "parse"));
        }
        return eslintCheckstyleProblems;
    }

    @Nullable
    private static String extractXml(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "extractXml"));
        }
        int startInd = output.indexOf("<?xml ");
        if (startInd == -1) {
            startInd = output.indexOf("<checkstyle");
        }
        if (startInd == -1) {
            return null;
        }
        return output.substring(startInd);
    }

    private static EslintCheckstyleProblems fail(@NotNull String failMessage) {
        if (failMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failMessage", "com/intellij/lang/javascript/linter/eslint/EslintCheckstyleProblems", "fail"));
        }
        return new EslintCheckstyleProblems(failMessage, Collections.emptyList());
    }

    private static class EslintContentHandler
    extends DefaultHandler {
        private static final String UNDEFINED = "undefined";
        private final List<JSLinterError> myErrors = ContainerUtil.newArrayList();
        private final boolean myOneBasedColumn;

        public EslintContentHandler(boolean oneBasedColumn) {
            this.myOneBasedColumn = oneBasedColumn;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("error".equals(qName)) {
                try {
                    int column;
                    String lineStr = attributes.getValue("line");
                    String columnStr = attributes.getValue("column");
                    String severityStr = attributes.getValue("severity");
                    String message = attributes.getValue("message");
                    String ruleCode = StringUtil.notNullize((String)attributes.getValue("source")).replaceFirst("eslint.rules.", "");
                    String userMessage = StringUtil.notNullize((String)message).replace("(" + ruleCode + ")", "").trim();
                    if (StringUtil.isEmpty((String)lineStr) || UNDEFINED.equals(lineStr)) {
                        if (!message.startsWith("File ignored")) {
                            LOG.warn("Unexpected ESLint error: {line:" + lineStr + ", column: " + columnStr + ", severity: " + severityStr + ", message: " + message + "}");
                        }
                        return;
                    }
                    int line = Integer.parseInt(lineStr);
                    if (StringUtil.isEmpty((String)columnStr) || UNDEFINED.equals(columnStr)) {
                        column = 0;
                    } else {
                        int c = Integer.parseInt(columnStr);
                        column = this.myOneBasedColumn ? c : c + 1;
                    }
                    HighlightSeverity severity = null;
                    if ("error".equals(severityStr)) {
                        severity = null;
                    } else if ("warning".equals(severityStr)) {
                        severity = HighlightSeverity.WARNING;
                    }
                    this.myErrors.add(new JSLinterError(line, column, userMessage, ruleCode, severity));
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
        }
    }
}

