/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigLangSubstitutor;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class EslintUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.eslint.EslintUtil");
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String CONFIG_SECTION_NAME = "eslintConfig";
    public static final String PACKAGE_NAME = "eslint";
    public static final String DEFAULT_CONFIG_PREFIX = ".eslintrc";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final String[] CONFIG_FILENAMES = new String[CONFIG_EXTENSIONS.length];
    private static final String[] CONFIG_FILENAMES_WITH_PACKAGE_JSON = new String[CONFIG_EXTENSIONS.length + 1];
    private static final String PLUGINS = "plugins";
    private static final String EXTENDS = "extends";
    private static final String HTML = "html";
    private static final String TYPESCRIPT = "typescript";
    public static final String VUE = "vue";

    private EslintUtil() {
    }

    public static boolean isEslintConfigFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        PsiFile file = element.getContainingFile();
        if (file != null) {
            file = file.getOriginalFile();
        }
        return file != null && EslintUtil.isEslintConfigFile(file);
    }

    public static boolean isEslintConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        return EslintUtil.isEslintConfigFile(file.getViewProvider().getVirtualFile());
    }

    public static boolean isEslintConfigFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        CharSequence name = file.getNameSequence();
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)DEFAULT_CONFIG_PREFIX)) {
            for (String ext : CONFIG_EXTENSIONS) {
                if (name.length() != DEFAULT_CONFIG_PREFIX.length() + ext.length() || !StringUtil.endsWith((CharSequence)name, (CharSequence)ext)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsWithPackageJsonUpFileSystem(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsWithPackageJsonUpFileSystem"));
        }
        List configs = ContainerUtil.newSmartList();
        for (VirtualFile dir = fileToLint.getParent(); dir != null; dir = dir.getParent()) {
            EslintUtil.addAllConfigsWithPackageJsonFromDir(dir, configs);
        }
        List list = configs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsWithPackageJsonUpFileSystem"));
        }
        return list;
    }

    private static void addAllConfigsWithPackageJsonFromDir(@NotNull VirtualFile dir, @NotNull List<VirtualFile> configs) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "addAllConfigsWithPackageJsonFromDir"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "addAllConfigsWithPackageJsonFromDir"));
        }
        for (String name : CONFIG_FILENAMES_WITH_PACKAGE_JSON) {
            VirtualFile file = dir.findChild(name);
            if (file == null || !file.isValid() || file.isDirectory()) continue;
            configs.add(file);
        }
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsInScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsInScope"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        EslintUtil.configFilesSearch(project, scope, (Processor<VirtualFile>)((Processor)file -> {
            result.add(file);
            return true;
        }));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsInScope"));
        }
        return arrayList;
    }

    public static boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "hasConfigFiles"));
        }
        Ref ref = new Ref((Object)false);
        EslintUtil.configFilesSearch(project, GlobalSearchScope.projectScope((Project)project), (Processor<VirtualFile>)((Processor)file -> {
            if (JSLinterGuesser.LOG.isDebugEnabled()) {
                JSLinterGuesser.LOG.debug("Found ESLint config: " + file.getPath());
            }
            ref.set((Object)true);
            return false;
        }));
        return Boolean.TRUE.equals(ref.get());
    }

    private static void configFilesSearch(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configFilesSearch"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configFilesSearch"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configFilesSearch"));
        }
        for (String name : CONFIG_FILENAMES) {
            FilenameIndex.processFilesByName((String)name, (boolean)false, file -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "lambda$configFilesSearch$2"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "lambda$configFilesSearch$2"));
                }
                return file.isValid() && !file.isDirectory() && !JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile(), project) && processor.process((Object)file.getVirtualFile());
            }, (GlobalSearchScope)scope, (Project)project, null);
        }
    }

    public static boolean configAllowsFileType(@NotNull PsiFile file, @NotNull Project project, @NotNull List<VirtualFile> configs) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configAllowsFileType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configAllowsFileType"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configAllowsFileType"));
        }
        HashSet<String> pluginNames = new HashSet<String>();
        if (JSLinterUtil.isPureHtmlFile(file) || JSLinterUtil.isVueFile(file)) {
            pluginNames.add(HTML);
            pluginNames.add(VUE);
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType())) {
            pluginNames.add(TYPESCRIPT);
        }
        if (pluginNames.isEmpty()) {
            return true;
        }
        return ContainerUtil.or(configs, configFile -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "lambda$configAllowsFileType$4"));
            }
            EslintConfigData configData = EslintUtil.parseConfigFile(project, configFile);
            return configData != null && configData.getPlugins().stream().anyMatch(p -> pluginNames.contains(p));
        });
    }

    @Nullable
    public static EslintConfigData parseConfigFile(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseConfigFile"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseConfigFile"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (EslintConfigData)ReadAction.compute(() -> {
            if (configFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "lambda$parseConfigFile$6"));
            }
            PsiFile psiFile = psiManager.findFile(configFile);
            if (psiFile == null) {
                return null;
            }
            CachedValueProvider provider = () -> {
                if (configFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "lambda$null$5"));
                }
                if (configFile.getLength() >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    return null;
                }
                EslintConfigData configData = EslintUtil.parseInternal(psiFile, psiFile.getLanguage());
                return CachedValueProvider.Result.create((Object)configData, (Object[])new Object[]{psiFile.getViewProvider().getVirtualFile()});
            };
            return (EslintConfigData)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider);
        });
    }

    @Nullable
    private static EslintConfigData parseInternal(@NotNull PsiFile configFile, @NotNull Language language) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseInternal"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseInternal"));
        }
        if (JSLinterConfigLangSubstitutor.YamlLanguageHolder.INSTANCE.equals(language)) {
            return EslintUtil.parseYamlConfig(configFile);
        }
        if (configFile instanceof JsonFile) {
            return EslintUtil.parseJsonConfig(configFile);
        }
        if (configFile instanceof JSFile) {
            return EslintUtil.parseJavaScriptConfig(configFile);
        }
        return null;
    }

    @Nullable
    private static EslintConfigData parseYamlConfig(@NotNull PsiFile configFile) {
        Map map;
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseYamlConfig"));
        }
        String content = EslintUtil.loadContentOrNull(configFile.getViewProvider().getVirtualFile());
        if (content == null) {
            return null;
        }
        try {
            map = (Map)new Yaml().load(content);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
        return new EslintConfigData(EslintUtil.getStringList(map.get(PLUGINS)), EslintUtil.getListOrSingleStringValue(map.get(EXTENDS)));
    }

    @Nullable
    private static EslintConfigData parseJsonConfig(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseJsonConfig"));
        }
        JsonObject eslintRootObject = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)configFile).getTopLevelValue(), JsonObject.class);
        if (eslintRootObject == null) {
            return null;
        }
        if ("package.json".equals(configFile.getName()) && (eslintRootObject = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)eslintRootObject, (String)CONFIG_SECTION_NAME, JsonObject.class)) == null) {
            return null;
        }
        List plugins = ContainerUtil.notNullize((List)JsonUtil.getChildAsStringList((JsonObject)eslintRootObject, (String)PLUGINS));
        List extendsList = ContainerUtil.notNullize((List)JsonUtil.getChildAsSingleStringOrList((JsonObject)eslintRootObject, (String)EXTENDS));
        return new EslintConfigData(plugins, extendsList);
    }

    @Nullable
    private static EslintConfigData parseJavaScriptConfig(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "parseJavaScriptConfig"));
        }
        Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)configFile, JSReferenceExpression.class);
        if (expressions.isEmpty()) {
            return null;
        }
        Ref ref = new Ref();
        ContainerUtil.or((Iterable)expressions, expression -> {
            if ((JSSymbolUtil.isAccurateReferenceExpressionName(expression, "module", "exports") || JSSymbolUtil.isAccurateReferenceExpressionName(expression, "exports")) && expression.getParent() instanceof JSDefinitionExpression && expression.equals(((JSDefinitionExpression)expression.getParent()).getExpression()) && ((JSDefinitionExpression)expression.getParent()).getInitializer() instanceof JSObjectLiteralExpression) {
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)((JSDefinitionExpression)expression.getParent()).getInitializer();
                assert (object != null);
                ref.set((Object)new EslintConfigData(ContainerUtil.notNullize(EslintUtil.getJSStringArrayOrSimplePropertyValues(object, PLUGINS)), ContainerUtil.notNullize(EslintUtil.getJSStringArrayOrSimplePropertyValues(object, EXTENDS))));
                return true;
            }
            return false;
        });
        return (EslintConfigData)ref.get();
    }

    private static List<String> getJSStringArrayOrSimplePropertyValues(@NotNull JSObjectLiteralExpression object, @NotNull String name) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getJSStringArrayOrSimplePropertyValues"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getJSStringArrayOrSimplePropertyValues"));
        }
        JSProperty property = object.findProperty(name);
        if (property != null) {
            if (property.getValue() instanceof JSArrayLiteralExpression) {
                JSExpression[] arrayExpressions = ((JSArrayLiteralExpression)property.getValue()).getExpressions();
                return Arrays.stream(arrayExpressions).filter(expr -> expr instanceof JSLiteralExpression && ((JSLiteralExpression)expr).isQuotedLiteral()).map(expr -> StringUtil.unquoteString((String)expr.getText())).collect(Collectors.toList());
            }
            if (property.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)property.getValue()).isQuotedLiteral()) {
                return Collections.singletonList(StringUtil.unquoteString((String)property.getValue().getText()));
            }
        }
        return null;
    }

    @Nullable
    private static String loadContentOrNull(VirtualFile configFile) {
        try {
            return VfsUtilCore.loadText((VirtualFile)configFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<String> getStringList(@Nullable Object value) {
        List list = value instanceof List ? (List)value : ContainerUtil.emptyList();
        List list2 = ContainerUtil.map((Collection)list, o -> o.toString());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getStringList"));
        }
        return list2;
    }

    @NotNull
    private static List<String> getListOrSingleStringValue(@Nullable Object value) {
        List<String> list = EslintUtil.getStringList(value);
        if (!list.isEmpty()) {
            List<String> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getListOrSingleStringValue"));
            }
            return list2;
        }
        String stringValue = value instanceof String ? (String)value : null;
        List list3 = !StringUtil.isEmpty((String)stringValue) ? ContainerUtil.list((Object[])new String[]{stringValue}) : ContainerUtil.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getListOrSingleStringValue"));
        }
        return list3;
    }

    static {
        for (int i = 0; i < CONFIG_EXTENSIONS.length; ++i) {
            EslintUtil.CONFIG_FILENAMES[i] = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i];
            EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[i] = CONFIG_FILENAMES[i];
        }
        EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON.length - 1] = "package.json";
    }

    public static class EslintConfigData {
        private List<String> myExtends;
        private List<String> myPlugins;

        public EslintConfigData(@NotNull List<String> plugins, @NotNull List<String> extended) {
            if (plugins == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EslintUtil.PLUGINS, "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData", "<init>"));
            }
            if (extended == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extended", "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData", "<init>"));
            }
            this.myExtends = extended;
            this.myPlugins = plugins;
        }

        @NotNull
        public List<String> getPlugins() {
            List<String> list = this.myPlugins;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData", "getPlugins"));
            }
            return list;
        }

        @NotNull
        public List<String> getExtends() {
            List<String> list = this.myExtends;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil$EslintConfigData", "getExtends"));
            }
            return list;
        }

        public String toString() {
            return "EslintConfigData{myExtends=" + StringUtil.join(this.myExtends, (String)",") + ", myPlugins=" + StringUtil.join(this.myPlugins, (String)",") + '}';
        }
    }
}

