/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.google.gson.JsonObject;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.linter.eslint.service.commands.ESLintFixErrorsCommand;
import com.intellij.lang.javascript.linter.eslint.service.commands.ESLintGetErrorsCommand;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ESLintBasedLanguageService<TStoredState extends JSNpmLinterState<TStoredState>>
extends JSLanguageServiceBase
implements EslintLanguageServiceClient {
    public ESLintBasedLanguageService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService", "<init>"));
        }
        super(project);
    }

    @Override
    @NotNull
    protected JSLanguageServiceQueue.ServiceInfoReporter createDefaultReporter() {
        JSLanguageServiceBase.NotificationLanguageServiceReporter notificationLanguageServiceReporter = new JSLanguageServiceBase.NotificationLanguageServiceReporter(this, JSLinterUtil.NOTIFICATION_GROUP, super.createDefaultReporter());
        if (notificationLanguageServiceReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService", "createDefaultReporter"));
        }
        return notificationLanguageServiceReporter;
    }

    @Override
    @Nullable
    public final Future<Pair<String, List<JSLinterError>>> highlight(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content, String extraOptions) {
        if (StringUtil.isEmptyOrSpaces((String)content) || virtualFile == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        String configPath = config == null ? null : JSLanguageServiceUtil.normalizeNameAndPath(config);
        String path = JSLanguageServiceUtil.normalizeNameAndPath(virtualFile);
        if (path == null) {
            return null;
        }
        ESLintGetErrorsCommand command = new ESLintGetErrorsCommand(path, configPath, StringUtil.notNullize((String)content), extraOptions);
        return process.execute(command, ESLintBasedLanguageService.createHighlightProcessor());
    }

    @Override
    @Nullable
    public final Future<Pair<String, List<JSLinterError>>> highlightAndFix(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, String extraOptions) {
        if (virtualFile == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        String configPath = config == null ? null : JSLanguageServiceUtil.normalizeNameAndPath(config);
        String path = JSLanguageServiceUtil.normalizeNameAndPath(virtualFile);
        if (path == null) {
            return null;
        }
        ESLintFixErrorsCommand command = new ESLintFixErrorsCommand(path, configPath, extraOptions);
        return process.execute(command, ESLintBasedLanguageService.createHighlightProcessor());
    }

    @NotNull
    protected abstract Class<? extends JSLinterConfiguration<TStoredState>> getConfigurationClass();

    protected abstract void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState var1, @NotNull TStoredState var2);

    @NotNull
    private static JSLanguageServiceCommandProcessor<Pair<String, List<JSLinterError>>> createHighlightProcessor() {
        JSLanguageServiceCommandProcessor<Pair<String, List<JSLinterError>>> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            String languageServiceError = JsonUtil.getChildAsString((JsonObject)answer.getElement(), (String)"error");
            if (languageServiceError != null) {
                return Pair.create((Object)languageServiceError, Collections.emptyList());
            }
            ESLintJsonProblemsParser parser = ESLintJsonProblemsParser.parse(answer.getElement());
            return Pair.create((Object)parser.getFileLevelError(), parser.getErrors());
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService", "createHighlightProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        return new JSLanguageServiceQueueImpl(this.myProject, new Protocol(this.myProject, Consumer.EMPTY_CONSUMER), this.myProcessConnector, this.myDefaultReporter, new JSLanguageServiceDefaultCacheData());
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("ESLint" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService", "getProcessName"));
        }
        return "ESLint";
    }

    @Override
    protected boolean needInitToolWindow() {
        return false;
    }

    @NotNull
    private ExtendedLinterState<TStoredState> getExtendedState() {
        ExtendedLinterState<TStoredState> extendedLinterState = JSLinterConfiguration.getInstance(this.myProject, this.getConfigurationClass()).getExtendedState();
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService", "getExtendedState"));
        }
        return extendedLinterState;
    }

    public class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(@NotNull Project project, Consumer<?> readyConsumer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol", "<init>"));
            }
            if (readyConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readyConsumer", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol", "<init>"));
            }
            super(project, readyConsumer);
        }

        public void dispose() {
        }

        @Override
        @Nullable
        protected String getNodeInterpreter() {
            ExtendedLinterState extendedState = ESLintBasedLanguageService.this.getExtendedState();
            return JSLanguageServiceUtil.getInterpreterPathIfValid(((JSNpmLinterState)extendedState.getState()).getInterpreterRef().resolve(this.myProject));
        }

        @Override
        protected JSLanguageServiceInitialState createState() {
            ESLintLanguageServiceInitialState protocolState = new ESLintLanguageServiceInitialState();
            ESLintBasedLanguageService.this.fillInitialProtocolState(protocolState, (JSNpmLinterState)ESLintBasedLanguageService.this.getExtendedState().getState());
            protocolState.pluginName = "ESLint";
            File service = new File(JSLanguageServiceUtil.getPluginDirectory(this.getClass(), "languageService"), "eslint/bin/eslint-plugin-provider.js");
            if (!service.exists()) {
                JSLanguageServiceQueue.LOGGER.info("ESLint plugin not found");
            }
            protocolState.pluginPath = service.getAbsolutePath();
            return protocolState;
        }
    }
}

