/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.eslint.JSLinterReformatterTask;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsExternalAnnotator;
import com.intellij.lang.javascript.linter.jscs.JscsExternalRunner;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JscsReformatterTask
extends JSLinterReformatterTask {
    public static final IntentionAction[] EMPTY = IntentionAction.EMPTY_ARRAY;
    private final JscsExternalAnnotator myJscsAnnotator;
    private final JscsState myJscsState;

    public JscsReformatterTask(@NotNull Project project, @NotNull Collection<VirtualFile> roots, @NotNull Runnable completionCallback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "<init>"));
        }
        if (completionCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionCallback", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "<init>"));
        }
        super(project, JSBundle.message((String)"settings.javascript.linters.jscs.configurable.name", (Object[])new Object[0]), roots, completionCallback);
        this.myJscsAnnotator = JscsExternalAnnotator.getInstanceForBatchInspection();
        this.myJscsState = (JscsState)JscsConfiguration.getInstance(this.myProject).getExtendedState().getState();
    }

    @Override
    protected void runLinter(@NotNull PsiFile psiFile, @NotNull Document document) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "runLinter"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/jscs/JscsReformatterTask", "runLinter"));
        }
        VirtualFile file = psiFile.getVirtualFile();
        JSLinterInput<JscsState> input = JSLinterInput.create(this.myProject, psiFile, psiFile.getText(), this.myJscsState, null);
        JscsExternalRunner runner = this.myJscsAnnotator.createJscsRunner(input);
        runner.setFix(true);
        JSLinterAnnotationResult<JscsState> result = runner.execute();
        this.processLinterRunnerOutput(file, result, false);
        if (runner.getSkipReason() != null) {
            this.error(file, runner.getSkipReason(), new IntentionAction[0]);
        }
    }
}

