/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditValueDialog
extends DialogWrapper {
    private final JPanel myComponent;
    private final TypePeer<Object> myTypePeer;

    public EditValueDialog(@NotNull Component parent, @NotNull String optionTitle, @NotNull JSHintOption option, @Nullable Object optionValue) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "<init>"));
        }
        if (optionTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionTitle", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "<init>"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "<init>"));
        }
        super(parent, false);
        this.myTypePeer = EditValueDialog.createTypePeer(option);
        this.myTypePeer.setValue(optionValue);
        this.myComponent = EditValueDialog.createComponent(optionTitle, this.myTypePeer);
        this.myComponent.setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));
        this.setTitle("Set '" + option.getKey() + "' Option");
        this.setOKButtonText("Set");
        this.init();
    }

    @NotNull
    private static TypePeer<?> createTypePeer(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createTypePeer"));
        }
        if (OptionTypes.isIntegerOption(option)) {
            IntegerTypePeer integerTypePeer = new IntegerTypePeer();
            if (integerTypePeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createTypePeer"));
            }
            return integerTypePeer;
        }
        if (OptionTypes.isStringOption(option)) {
            StringTypePeer stringTypePeer = new StringTypePeer();
            if (stringTypePeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createTypePeer"));
            }
            return stringTypePeer;
        }
        if (OptionTypes.isEnumOption(option)) {
            OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
            EnumTypePeer enumTypePeer = new EnumTypePeer(enumType);
            if (enumTypePeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createTypePeer"));
            }
            return enumTypePeer;
        }
        throw new RuntimeException("Unexpected option type: " + option.getType());
    }

    @NotNull
    private static <T> JPanel createComponent(@NotNull String optionTitle, @NotNull TypePeer<T> typePeer) {
        if (optionTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionTitle", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createComponent"));
        }
        if (typePeer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePeer", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createComponent"));
        }
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        String labelLocation = typePeer.isHorizontallyStacked() ? "West" : "North";
        panel.add((Component)new JLabel(optionTitle + ":"), labelLocation);
        panel.add((Component)typePeer.getComponent(), "Center");
        if (typePeer instanceof IntegerTypePeer) {
            JLabel hintLabel = new JLabel("Clear field to disable", 4);
            hintLabel.setFont(UIUtil.getTitledBorderFont());
            panel.add((Component)SwingHelper.newVerticalPanel((float)1.0f, (Component[])new Component[]{Box.createVerticalStrut(5), hintLabel}), "South");
        }
        if (typePeer.isHorizontallyStacked()) {
            JPanel jPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createComponent"));
            }
            return jPanel;
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog", "createComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTypePeer.getComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myTypePeer.doValidate();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    @Nullable
    public Object getValue() {
        return this.myTypePeer.getValue();
    }

    private static class EnumTypePeer
    implements TypePeer<Object> {
        private final OptionEnumType myEnumType;
        private final ButtonGroup myButtonGroup;
        private final JPanel myPanel;
        private final Map<ButtonModel, OptionEnumVariant> myVariantByModelMap;
        private final Map<OptionEnumVariant, ButtonModel> myModelByVariantMap;

        private EnumTypePeer(@NotNull OptionEnumType enumType) {
            if (enumType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumType", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$EnumTypePeer", "<init>"));
            }
            this.myVariantByModelMap = new IdentityHashMap<ButtonModel, OptionEnumVariant>();
            this.myModelByVariantMap = new IdentityHashMap<OptionEnumVariant, ButtonModel>();
            this.myEnumType = enumType;
            this.myButtonGroup = new ButtonGroup();
            ArrayList components = ContainerUtil.newArrayList();
            boolean first = true;
            for (OptionEnumVariant variant : enumType.getVariants()) {
                String html = "<html><body><strong>" + variant.getValueAsJsonStr() + "</strong></body></html>";
                JRadioButton radioButton = new JRadioButton(html);
                this.myButtonGroup.add(radioButton);
                this.myModelByVariantMap.put(variant, radioButton.getModel());
                this.myVariantByModelMap.put(radioButton.getModel(), variant);
                JPanel radioButtonPanel = SwingHelper.wrapWithoutStretch((JComponent)radioButton);
                if (!first) {
                    radioButtonPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                }
                first = false;
                components.add(radioButtonPanel);
                JPanel descriptionPanel = EnumTypePeer.createDescriptionPanel(radioButton, variant);
                components.add(descriptionPanel);
            }
            this.myPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)SwingHelper.newLeftAlignedVerticalPanel((Collection)components));
        }

        private static JPanel createDescriptionPanel(@NotNull JRadioButton button, @NotNull OptionEnumVariant variant) {
            if (button == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$EnumTypePeer", "createDescriptionPanel"));
            }
            if (variant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$EnumTypePeer", "createDescriptionPanel"));
            }
            int leftMargin = button.getMargin().left + EnumTypePeer.getRadioIconWidth() + button.getIconTextGap();
            JPanel result = new JPanel(new FlowLayout(0, 0, 0));
            JLabel label = new JLabel(variant.getValueDescription());
            label.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            result.add(label);
            return result;
        }

        private static int getRadioIconWidth() {
            Icon icon = UIManager.getIcon("RadioButton.icon");
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 12;
        }

        @Override
        public boolean isHorizontallyStacked() {
            return false;
        }

        @Override
        @Nullable
        public Object getValue() {
            ButtonModel model = this.myButtonGroup.getSelection();
            if (model == null) {
                return null;
            }
            OptionEnumVariant variant = this.myVariantByModelMap.get(model);
            if (variant == null) {
                throw new RuntimeException("No variant found!");
            }
            return variant.getValue();
        }

        @Override
        public void setValue(@Nullable Object value) {
            if (value == null) {
                throw new RuntimeException("Unexpected null for enum!");
            }
            OptionEnumVariant variant = this.myEnumType.getVariantByValue(value);
            if (variant == null) {
                throw new RuntimeException("Invalid enum value!");
            }
            ButtonModel model = this.myModelByVariantMap.get(variant);
            if (model == null) {
                throw new RuntimeException("Unexpected null");
            }
            model.setSelected(true);
        }

        @Override
        @Nullable
        public ValidationInfo doValidate() {
            return null;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$EnumTypePeer", "getComponent"));
            }
            return jPanel;
        }
    }

    private static class StringTypePeer
    implements TypePeer<String> {
        private final JBScrollPane myScrollPane;
        private final JTextArea myTextArea = new JTextArea();

        private StringTypePeer() {
            this.myTextArea.setLineWrap(true);
            this.myTextArea.setWrapStyleWord(true);
            this.myScrollPane = new JBScrollPane((Component)this.myTextArea);
            this.myScrollPane.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        }

        @Override
        public boolean isHorizontallyStacked() {
            return false;
        }

        @Override
        @Nullable
        public String getValue() {
            return this.getText();
        }

        @Override
        public void setValue(@Nullable String value) {
            this.myTextArea.setText(StringUtil.notNullize((String)value));
        }

        @Override
        @Nullable
        public ValidationInfo doValidate() {
            return null;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JBScrollPane jBScrollPane = this.myScrollPane;
            if (jBScrollPane == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$StringTypePeer", "getComponent"));
            }
            return jBScrollPane;
        }

        @NotNull
        private String getText() {
            String string = StringUtil.notNullize((String)this.myTextArea.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$StringTypePeer", "getText"));
            }
            return string;
        }
    }

    private static class IntegerTypePeer
    implements TypePeer<Integer> {
        private final JTextField myTextField = new JTextField();

        private IntegerTypePeer() {
            this.myTextField.setColumns(6);
        }

        @Override
        public boolean isHorizontallyStacked() {
            return true;
        }

        @Override
        @Nullable
        public Integer getValue() {
            return IntegerTypePeer.toInteger(this.getText());
        }

        @Override
        public void setValue(@Nullable Integer value) {
            String text = value == null ? "" : value.toString();
            this.myTextField.setText(text);
        }

        @Override
        @Nullable
        public ValidationInfo doValidate() {
            OptionType<Integer> intType;
            Integer value;
            String text = this.getText();
            if (!(text.isEmpty() || (value = (intType = OptionTypes.INTEGER).fromString(text)) != null && intType.isValidValue(value))) {
                return new ValidationInfo("Illegal integer", (JComponent)this.myTextField);
            }
            return null;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JTextField jTextField = this.myTextField;
            if (jTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$IntegerTypePeer", "getComponent"));
            }
            return jTextField;
        }

        @Nullable
        private static Integer toInteger(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$IntegerTypePeer", "toInteger"));
            }
            try {
                return Integer.parseInt(text);
            }
            catch (Exception e) {
                return null;
            }
        }

        @NotNull
        private String getText() {
            String string = StringUtil.notNullize((String)this.myTextField.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/EditValueDialog$IntegerTypePeer", "getText"));
            }
            return string;
        }
    }

    private static interface TypePeer<T> {
        public boolean isHorizontallyStacked();

        @Nullable
        public T getValue();

        public void setValue(@Nullable T var1);

        @Nullable
        public ValidationInfo doValidate();

        @NotNull
        public JComponent getComponent();
    }
}

