/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.option;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.linter.option.Option;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionEnumType
implements OptionType<Object> {
    private final List<OptionEnumVariant> myVariants;
    private final Map<String, OptionEnumVariant> myVariantByValueStr;

    public OptionEnumType(@NotNull List<OptionEnumVariant> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/linter/option/OptionEnumType", "<init>"));
        }
        this.myVariants = ImmutableList.copyOf(variants);
        this.myVariantByValueStr = ContainerUtil.newMapFromValues(variants.iterator(), (Convertor)new Convertor<OptionEnumVariant, String>(){

            public String convert(OptionEnumVariant o) {
                return o.getValue().toString();
            }
        });
    }

    @NotNull
    public List<OptionEnumVariant> getVariants() {
        List<OptionEnumVariant> list = this.myVariants;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumType", "getVariants"));
        }
        return list;
    }

    @Override
    @Nullable
    public Object fromString(@NotNull String valueStr) {
        if (valueStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/option/OptionEnumType", "fromString"));
        }
        OptionEnumVariant variant = this.myVariantByValueStr.get(StringUtil.stripQuotesAroundValue((String)valueStr));
        return variant == null ? null : variant.getValue();
    }

    @Override
    public boolean isValidValue(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/option/OptionEnumType", "isValidValue"));
        }
        OptionEnumVariant variant = this.getVariantByValue(value);
        return variant != null;
    }

    @Nullable
    public OptionEnumVariant getVariantByValue(@Nullable Object value) {
        for (OptionEnumVariant variant : this.myVariants) {
            if (!variant.getValue().equals(value)) continue;
            return variant;
        }
        return null;
    }

    public String toString() {
        List values = ContainerUtil.map(this.myVariants, variant -> variant.toString());
        return "enum (" + StringUtil.join((Collection)values, (String)",") + ")";
    }

    @NotNull
    public static OptionEnumVariant findVariantByValueOrFail(@NotNull Option option, @Nullable Object value) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/option/OptionEnumType", "findVariantByValueOrFail"));
        }
        if (!OptionTypes.isEnumOption(option)) {
            throw new RuntimeException("Option " + option + " has " + option.getType() + " type, but enum type was expected.");
        }
        OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
        OptionEnumVariant variant = enumType.getVariantByValue(value);
        if (variant == null) {
            throw new RuntimeException("[option '" + option.getKey() + "'] Enum variant not found for " + value);
        }
        OptionEnumVariant optionEnumVariant = variant;
        if (optionEnumVariant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionEnumType", "findVariantByValueOrFail"));
        }
        return optionEnumVariant;
    }
}

