/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.option;

import com.intellij.lang.javascript.linter.option.Option;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionTypes {
    public static final OptionType<Boolean> BOOLEAN = new BooleanOptionType();
    public static final OptionType<Integer> INTEGER = new IntegerOptionType();
    public static final OptionType<String> STRING = new StringOptionType();
    public static final String ANY_VALUE = "any";

    public static boolean isBooleanOption(@NotNull Option<?> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/option/OptionTypes", "isBooleanOption"));
        }
        return BOOLEAN.equals(option.getType());
    }

    public static boolean isStringOption(@NotNull Option<?> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/option/OptionTypes", "isStringOption"));
        }
        return STRING.equals(option.getType());
    }

    public static boolean isIntegerOption(@NotNull Option<?> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/option/OptionTypes", "isIntegerOption"));
        }
        return INTEGER.equals(option.getType());
    }

    public static boolean isEnumOption(@NotNull Option<?> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/option/OptionTypes", "isEnumOption"));
        }
        return option.getType() instanceof OptionEnumType;
    }

    @NotNull
    public static OptionEnumType getOptionEnumType(@NotNull Option<?> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/option/OptionTypes", "getOptionEnumType"));
        }
        OptionEnumType optionEnumType = (OptionEnumType)option.getType();
        if (optionEnumType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/option/OptionTypes", "getOptionEnumType"));
        }
        return optionEnumType;
    }

    private static class StringOptionType
    implements OptionType<String> {
        private StringOptionType() {
        }

        @Override
        @Nullable
        public String fromString(@NotNull String valueStr) {
            if (valueStr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/option/OptionTypes$StringOptionType", "fromString"));
            }
            return valueStr;
        }

        @Override
        public boolean isValidValue(@NotNull String optionValue) {
            if (optionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/lang/javascript/linter/option/OptionTypes$StringOptionType", "isValidValue"));
            }
            return true;
        }

        public String toString() {
            return "string";
        }
    }

    private static class IntegerOptionType
    implements OptionType<Integer> {
        private IntegerOptionType() {
        }

        @Override
        @Nullable
        public Integer fromString(@NotNull String valueStr) {
            if (valueStr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/option/OptionTypes$IntegerOptionType", "fromString"));
            }
            try {
                return Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public boolean isValidValue(@NotNull Integer optionValue) {
            if (optionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/lang/javascript/linter/option/OptionTypes$IntegerOptionType", "isValidValue"));
            }
            return optionValue >= 0;
        }

        public String toString() {
            return "integer";
        }
    }

    private static class BooleanOptionType
    implements OptionType<Boolean> {
        private BooleanOptionType() {
        }

        @Override
        @Nullable
        public Boolean fromString(@NotNull String valueStr) {
            if (valueStr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueStr", "com/intellij/lang/javascript/linter/option/OptionTypes$BooleanOptionType", "fromString"));
            }
            if (Boolean.TRUE.toString().equals(valueStr)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equals(valueStr)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean isValidValue(@NotNull Boolean optionValue) {
            if (optionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/lang/javascript/linter/option/OptionTypes$BooleanOptionType", "isValidValue"));
            }
            return true;
        }

        public String toString() {
            return "boolean";
        }
    }
}

