/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.rhino;

import com.google.common.base.Supplier;
import com.intellij.lang.javascript.linter.rhino.FunctionWithScope;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoFunctionManager {
    private static final Logger LOG = Logger.getInstance(RhinoFunctionManager.class);
    private final ThreadLocal<FunctionWithScope> myThreadLocalFunction;
    private volatile Script myScript;
    private final Supplier<String> myScriptSourceProvider;
    private final String myFunctionName;
    private final String myVersion;

    public RhinoFunctionManager(@NotNull Supplier<String> scriptSourceProvider, @NotNull String functionName, @Nullable String version) {
        if (scriptSourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptSourceProvider", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "<init>"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "<init>"));
        }
        this.myThreadLocalFunction = new ThreadLocal<FunctionWithScope>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected FunctionWithScope initialValue() {
                if (RhinoFunctionManager.this.myScript == null) {
                    ThreadLocal threadLocal = RhinoFunctionManager.this.myThreadLocalFunction;
                    synchronized (threadLocal) {
                        if (RhinoFunctionManager.this.myScript == null) {
                            RhinoFunctionManager.this.myScript = RhinoFunctionManager.this.compileScript(9);
                        }
                    }
                }
                return RhinoFunctionManager.this.extractFunctionWithScope(RhinoFunctionManager.this.myScript);
            }
        };
        this.myScriptSourceProvider = scriptSourceProvider;
        this.myFunctionName = functionName;
        this.myVersion = version;
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "getFunctionName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script compileScript(int optimizationLevel) {
        long startNano = System.nanoTime();
        Context context = Context.enter();
        try {
            context.setOptimizationLevel(optimizationLevel);
            String scriptSource = (String)this.myScriptSourceProvider.get();
            Script script = context.compileString(scriptSource, "<" + this.myFunctionName + " script>", 1, null);
            return script;
        }
        finally {
            Context.exit();
            LOG.info(RhinoFunctionManager.formatMessage(startNano, this.prependVersion("script rhino compilation")));
        }
    }

    @NotNull
    private String prependVersion(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "prependVersion"));
        }
        StringBuilder out = new StringBuilder(this.myFunctionName).append(" ");
        if (this.myVersion != null) {
            out.append(this.myVersion).append(" ");
        }
        out.append(message);
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "prependVersion"));
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private FunctionWithScope extractFunctionWithScope(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "extractFunctionWithScope"));
        }
        long startNano = System.nanoTime();
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        script.exec(context, (Scriptable)scope);
        Object jsLintObj = scope.get(this.myFunctionName, (Scriptable)scope);
        if (!(jsLintObj instanceof Function)) throw new RuntimeException(this.prependVersion("is undefined or not a function."));
        Function jsLint = (Function)jsLintObj;
        FunctionWithScope functionWithScope = new FunctionWithScope(jsLint, (Scriptable)scope);
        FunctionWithScope functionWithScope2 = functionWithScope;
        if (functionWithScope2 != null) return functionWithScope2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "extractFunctionWithScope"));
        finally {
            Context.exit();
            LOG.info(RhinoFunctionManager.formatMessage(startNano, this.prependVersion("function extraction")));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String formatMessage(long startTimeNano, @NotNull String string) {
        void actionName;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "formatMessage"));
        }
        long nanoDuration = System.nanoTime() - startTimeNano;
        return String.format("[%s] %s took %.2f ms", Thread.currentThread().getName(), actionName, (double)nanoDuration / 1000000.0);
    }

    @NotNull
    public FunctionWithScope getFunctionWithScope() {
        FunctionWithScope functionWithScope = this.myThreadLocalFunction.get();
        if (functionWithScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/rhino/RhinoFunctionManager", "getFunctionWithScope"));
        }
        return functionWithScope;
    }
}

