/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JSLiteralExpressionReferenceInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.LocalReferenceResolver;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseModulesDependenciesElementVisitor
extends JSElementVisitor {
    private static final Key<Set<VirtualFile>> ourPredefinedLibrariesKey = Key.create((String)"NodeJs.Predefined.Libraies");
    private static final Key<Set<String>> ourDefines = Key.create((String)"NodeJs.Defined.Variables");
    protected final LocalInspectionToolSession mySession;
    private final ProblemsHolder myHolder;
    private final boolean myOnTheFly;
    private static final Set<String> BROWSER_GLOBALS = new HashSet<String>();

    public JSBaseModulesDependenciesElementVisitor(LocalInspectionToolSession session, ProblemsHolder holder, boolean onTheFly) {
        BROWSER_GLOBALS.add("document");
        BROWSER_GLOBALS.add("navigator");
        BROWSER_GLOBALS.add("screen");
        BROWSER_GLOBALS.add("history");
        BROWSER_GLOBALS.add("location");
        this.mySession = session;
        this.myHolder = holder;
        this.myOnTheFly = onTheFly;
    }

    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "visitJSReferenceExpression"));
        }
        if (!DialectDetector.isJavaScript((PsiElement)node.getContainingFile()) || !JSBaseModulesDependenciesElementVisitor.checkContext(node)) {
            return;
        }
        JSExpression qualifier = node.getQualifier();
        if (qualifier != null) {
            return;
        }
        ProblemHighlightType unresolvedReferenceHighlightType = JSBaseModulesDependenciesElementVisitor.getUnresolvedReferenceHighlightType(node);
        if (!ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.equals((Object)unresolvedReferenceHighlightType)) {
            return;
        }
        if (JSBaseModulesDependenciesElementVisitor.predefinedModulesWords(StringUtil.notNullize((String)node.getText()))) {
            return;
        }
        JSModuleReferenceExpressionInfo moduleReferenceInfo = new JSModuleReferenceExpressionInfo(node);
        if (moduleReferenceInfo.getModuleName() == null) {
            return;
        }
        if (JSBaseModulesDependenciesElementVisitor.predefinedModulesWords(StringUtil.notNullize((String)moduleReferenceInfo.getTopLevelMember()))) {
            return;
        }
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo);
        if (modulesSuggester == null) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        this.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, resolveResults);
    }

    private static boolean checkContext(JSReferenceExpression node) {
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class);
        if (embeddedContent != null) {
            PsiElement parent = embeddedContent.getParent();
            return parent.getNode().getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE;
        }
        return true;
    }

    public void visitJSLiteralExpression(JSLiteralExpression node) {
        if (!(node instanceof JSXmlLiteralExpressionImpl) || !DialectDetector.isJSX((PsiElement)node.getContainingFile())) {
            return;
        }
        String name = node.getName();
        if (!StringUtil.isCapitalized((String)name)) {
            return;
        }
        JSXmlLiteralExpressionImpl xmlLiteralExpression = (JSXmlLiteralExpressionImpl)node;
        boolean isResolved = JSXHarmonyLanguageDialect.areReferencesResolvedOrEmpty(xmlLiteralExpression);
        if (isResolved) {
            return;
        }
        JSLiteralExpressionReferenceInfo moduleReferenceInfo = new JSLiteralExpressionReferenceInfo(xmlLiteralExpression);
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo);
        if (modulesSuggester == null) {
            return;
        }
        this.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, ResolveResult.EMPTY_ARRAY);
    }

    private void processResolvedElements(@NotNull PsiElement node, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull JsModulesSuggester modulesSuggester, @NotNull ResolveResult[] resolveResults) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "processResolvedElements"));
        }
        if (moduleReferenceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReferenceInfo", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "processResolvedElements"));
        }
        if (modulesSuggester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesSuggester", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "processResolvedElements"));
        }
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "processResolvedElements"));
        }
        if (this.shouldAddFixes(node, resolveResults, modulesSuggester)) {
            String inspectionText = this.getInspectionText();
            modulesSuggester.findFixes(resolveResults, JSBaseModulesDependenciesElementVisitor.cacheAndGetPredefinedLibraries(this.myHolder.getProject(), this.mySession));
            if (modulesSuggester.isEmpty()) {
                return;
            }
            List<Pair<PsiElement, List<LocalQuickFix>>> fixes = modulesSuggester.getFixes();
            for (int i = 0; i < fixes.size(); ++i) {
                Pair<PsiElement, List<LocalQuickFix>> pair = fixes.get(i);
                List<LocalQuickFix> list = (List<LocalQuickFix>)pair.getSecond();
                if ((list = JSBaseModulesDependenciesElementVisitor.sortAndFilter(list, moduleReferenceInfo)).isEmpty()) {
                    return;
                }
                if (i == 0 && !this.checkDefines(this.mySession, list)) {
                    return;
                }
                PsiElement currentElement = (PsiElement)pair.getFirst();
                ProblemHighlightType highlightType = JSBaseModulesDependenciesElementVisitor.getProblemHighlightType(currentElement);
                PsiReference reference = currentElement.getReference();
                if (reference == null) continue;
                this.myHolder.registerProblemForReference(reference, highlightType, inspectionText, list.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static ProblemHighlightType getProblemHighlightType(PsiElement element) {
        if (element instanceof JSReferenceExpression) {
            ResolveResult[] results = ((JSReferenceExpression)element).multiResolve(false);
            return results.length == 1 && !results[0].isValidResult() ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    protected abstract String getInspectionText();

    @Nullable
    protected abstract JsModulesSuggester createSuggester(@NotNull PsiElement var1, @NotNull ModuleReferenceInfo var2);

    @NotNull
    public static List<LocalQuickFix> sortAndFilter(@NotNull List<LocalQuickFix> fixes, ModuleReferenceInfo moduleReferenceInfo) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "sortAndFilter"));
        }
        ArrayList<LocalQuickFix> sublist = new ArrayList<LocalQuickFix>();
        for (LocalQuickFix fix : fixes) {
            String path;
            if (!(fix instanceof ImportCommonJSModuleFix) || !(path = ((ImportCommonJSModuleFix)fix).getPath()).equals(moduleReferenceInfo.getModuleName()) && !path.startsWith(moduleReferenceInfo.getModuleName() + "/")) continue;
            sublist.add(fix);
        }
        if (!sublist.isEmpty()) {
            ArrayList<LocalQuickFix> arrayList = sublist;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "sortAndFilter"));
            }
            return arrayList;
        }
        List<LocalQuickFix> list = fixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "sortAndFilter"));
        }
        return list;
    }

    private static ProblemHighlightType getUnresolvedReferenceHighlightType(JSReferenceExpression node) {
        if (node.getQualifier() == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    private static boolean predefinedModulesWords(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "predefinedModulesWords"));
        }
        return "require".equals(text) || "define".equals(text) || "module".equals(text) || "exports".equals(text) || "window".equals(text) || "global".equals(text) || "arguments".equals(text) || BROWSER_GLOBALS.contains(text.toLowerCase());
    }

    private boolean shouldAddFixes(@NotNull PsiElement refExpression, @NotNull ResolveResult[] resolveResults, JsModulesSuggester modulesSuggester) {
        if (refExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpression", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "shouldAddFixes"));
        }
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "shouldAddFixes"));
        }
        PsiFile file = refExpression.getContainingFile();
        if (new LocalReferenceResolver(file).checkResolveResults(resolveResults)) {
            return false;
        }
        if (resolveResults.length == 0) {
            return true;
        }
        for (ResolveResult result : resolveResults) {
            if (result instanceof JSResolveResult && ((JSResolveResult)result).wasES6ImportUsed()) {
                return false;
            }
            if (!modulesSuggester.isResolvedGlobally(result, JSBaseModulesDependenciesElementVisitor.cacheAndGetPredefinedLibraries(this.myHolder.getProject(), this.mySession))) continue;
            return false;
        }
        return true;
    }

    private boolean checkDefines(@NotNull LocalInspectionToolSession session, @NotNull List<LocalQuickFix> fixes) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "checkDefines"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "checkDefines"));
        }
        if (this.myOnTheFly) {
            return true;
        }
        if (fixes.isEmpty()) {
            return false;
        }
        Set data = (Set)session.getUserData(ourDefines);
        String varName = ((ImportJSModuleBaseFix)fixes.get(0)).getVarName();
        if (data != null && data.contains(varName)) {
            return false;
        }
        data = data == null ? new HashSet() : data;
        data.add(varName);
        session.putUserData(ourDefines, (Object)data);
        return true;
    }

    @NotNull
    public static Set<VirtualFile> cacheAndGetPredefinedLibraries(Project project, LocalInspectionToolSession session) {
        Set libraryFiles = (Set)session.getUserData(ourPredefinedLibrariesKey);
        if (libraryFiles != null) {
            Set set = libraryFiles;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "cacheAndGetPredefinedLibraries"));
            }
            return set;
        }
        libraryFiles = ContainerUtil.newHashSet(JSLibraryManager.getInstance(project).getRequiredLibraryFiles());
        PsiFile psiFile = session.getFile();
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(psiFile.getProject());
            Set result = libraryFiles;
            libraryMappings.iterateOverAssociatedLibraries(file, model -> model.collectFilesWithGlobalDefinitions((Collection)result));
        }
        session.putUserData(ourPredefinedLibrariesKey, (Object)libraryFiles);
        Set set = libraryFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "cacheAndGetPredefinedLibraries"));
        }
        return set;
    }

    public static boolean isForBrowser(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "isForBrowser"));
        }
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "isForBrowser"));
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        return mappings.isLibraryInScopeFor(vf, "HTML");
    }
}

