/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramModel;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiEdge;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

class JSDiagramColorManager
extends DiagramColorManagerBase {
    public static final JSDiagramColorManager INSTANCE = new JSDiagramColorManager();

    JSDiagramColorManager() {
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        Object element;
        Object object = element = node == null ? null : node.getIdentifyingElement();
        if (element instanceof JSStructuralDiagramItem) {
            PsiFile file;
            String module;
            JSStructuralDiagramModel model = (JSStructuralDiagramModel)builder.getDataModel();
            JSStructuralDiagramItem diagramItem = (JSStructuralDiagramItem)element;
            String name = diagramItem.getName();
            int idx = name.indexOf("/");
            String string = module = idx > 0 ? name.substring(0, idx) : "";
            Color color = diagramItem.isInScope() && diagramItem.getElementPointer() != null ? ((file = diagramItem.getElementPointer().getContainingFile()) != null && JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile()) ? model.getColoredGenerator().generate(module) : model.getInProjectGenerator().generate(module)) : model.getGrayGenerator().generate(module);
            return color;
        }
        return super.getNodeHeaderColor(builder, node);
    }

    public boolean drawGradientInHeader() {
        return false;
    }

    public Color getNodeForegroundColor(boolean selected) {
        if (UIUtil.isUnderDarcula()) {
            return JBColor.black;
        }
        return super.getNodeForegroundColor(selected);
    }

    public Color getEdgeColor(DiagramEdge edge) {
        Color color;
        if (edge instanceof JSStructuralUiEdge && (color = ((JSStructuralUiEdge)edge).getColor()) != null) {
            return color;
        }
        return JBColor.gray;
    }

    public Color getNodeBackground(Project project, Object element, boolean selected) {
        if (element instanceof JSStructuralDiagramItem) {
            if (((JSStructuralDiagramItem)element).getParent() != null) {
                return JBColor.WHITE;
            }
            if (((JSStructuralDiagramItem)element).isInScope()) {
                return LightColors.YELLOW;
            }
            return Gray._250;
        }
        return super.getNodeBackground(project, element, selected);
    }
}

