/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModulesDiagramUtils {
    public static final DataKey<DiagramBuilder> DIAGRAM_BUILDER = DataKey.create((String)"JS.Diagram.Builder");

    public static String getFileNamePart(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "getFileNamePart"));
        }
        if (NodeJsCoreLibraryManager.getInstance(file.getProject()).isCoreModuleLibraryFile(file.getVirtualFile())) {
            return file.getName() + " (node.js)";
        }
        VirtualFile folder = JSLibraryUtil.getLibraryFolder(file.getVirtualFile());
        VirtualFile parent = file.getVirtualFile().getParent();
        if (folder != null) {
            if (folder.equals(parent)) {
                return folder.getName() + "/" + file.getName();
            }
            return folder.getName() + "/.../" + file.getName();
        }
        if (file.getProject().getBaseDir().equals(parent)) {
            return file.getName();
        }
        return (parent == null ? "" : parent.getName() + "/") + file.getName();
    }

    @Nullable
    public static String getJSStructuralItemTooltip(JSStructuralDiagramItem element) {
        if (element.getElementPointer() == null) {
            if (JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                return element.getName();
            }
            return element.getName() + " (not found)";
        }
        PsiElement psiElement = element.getElementPointer().getElement();
        if (psiElement != null && psiElement.isValid()) {
            if (!element.isFile()) {
                return element.getName() + " (" + psiElement.getContainingFile().getVirtualFile().getPath() + ")";
            }
            return psiElement.getContainingFile().getVirtualFile().getPath();
        }
        return element.getName();
    }

    public static boolean startsWithHttpProtocol(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "startsWithHttpProtocol"));
        }
        int idx = s.indexOf("://");
        return idx > 0 && s.substring(0, idx).startsWith("http");
    }

    @Nullable
    public static List<DiagramNode> getSelectedNodes(AnActionEvent e) {
        DiagramBuilder builder = (DiagramBuilder)DIAGRAM_BUILDER.getData(e.getDataContext());
        if (builder == null || builder.getGraph().isSelectionEmpty()) {
            return null;
        }
        UmlGraphBuilder umlBuilder = (UmlGraphBuilder)builder.getGraph().getDataProvider((Object)"GRAPH_BUILDER").get(null);
        return new ArrayList<DiagramNode>(GraphUtil.getSelectedNodes((GraphBuilder)umlBuilder));
    }

    public static void showMembersSelectionPopup(@NotNull String mainName, @Nullable SmartPsiElementPointer mainPointer, final @Nullable Icon mainIcon, final @NotNull List<Trinity<String, SmartPsiElementPointer, Icon>> children, @NotNull DataContext dc) {
        if (mainName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainName", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "showMembersSelectionPopup"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "showMembersSelectionPopup"));
        }
        if (dc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dc", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "showMembersSelectionPopup"));
        }
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(mainName);
        for (Trinity<String, SmartPsiElementPointer, Icon> pair : children) {
            data.add(pair.getFirst());
        }
        JBList list = new JBList();
        list.setListData(ArrayUtil.toObjectArray(data));
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils$1", "customizeCellRenderer"));
                }
                if (index < 0 || index > children.size()) {
                    return;
                }
                if (index == 0) {
                    this.setIcon(mainIcon);
                } else {
                    this.setIcon((Icon)((Trinity)children.get(index - 1)).getThird());
                }
                this.append(value.toString());
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select Navigation Target").setItemChoosenCallback(() -> {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "lambda$showMembersSelectionPopup$0"));
            }
            if (dc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dc", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "lambda$showMembersSelectionPopup$0"));
            }
            int index = list.getSelectedIndex();
            if (index >= 0) {
                SmartPsiElementPointer target;
                SmartPsiElementPointer smartPsiElementPointer = target = index == 0 ? mainPointer : (SmartPsiElementPointer)((Trinity)children.get(index - 1)).getSecond();
                if (target != null) {
                    PsiElement element = target.getElement();
                    int offset = element == null ? 0 : (element instanceof JSImplicitElement ? element.getTextOffset() : element.getTextRange().getStartOffset());
                    new OpenFileDescriptor((Project)CommonDataKeys.PROJECT.getData(dc), target.getVirtualFile(), offset).navigate(true);
                }
            }
        }).createPopup().showInBestPositionFor(dc);
    }
}

