/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralDiagramItem {
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    private final String myName;
    private final boolean myIsFile;
    private JSStructuralDiagramItem myParent;
    @NotNull
    private final List<JSStructuralDiagramItem> myUsedExported = new ArrayList<JSStructuralDiagramItem>();
    @NotNull
    private final Set<JSStructuralDiagramItem> myExported;
    private boolean myIsInScope;
    private Icon myIcon;

    public JSStructuralDiagramItem(@Nullable SmartPsiElementPointer<PsiElement> elementPointer, String name, boolean isFile) {
        this.myElementPointer = elementPointer;
        this.myName = name;
        this.myIsFile = isFile;
        this.myExported = new HashSet<JSStructuralDiagramItem>();
    }

    @Nullable
    public SmartPsiElementPointer<PsiElement> getElementPointer() {
        return this.myElementPointer;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    @NotNull
    public List<JSStructuralDiagramItem> getUsedExported() {
        List<JSStructuralDiagramItem> list = Collections.unmodifiableList(this.myUsedExported);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "getUsedExported"));
        }
        return list;
    }

    public void addImportedOrExported(@NotNull JSStructuralDiagramItem item, boolean exported) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "addImportedOrExported"));
        }
        this.myUsedExported.add(item);
        if (exported) {
            this.myExported.add(item);
        }
        item.setParent(this);
    }

    public boolean isExported(@NotNull JSStructuralDiagramItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "isExported"));
        }
        return this.myExported.contains(item);
    }

    public void sortExported() {
        if (this.myUsedExported.isEmpty()) {
            return;
        }
        TreeSet<JSStructuralDiagramItem> set = new TreeSet<JSStructuralDiagramItem>((o1, o2) -> Comparing.compare((Comparable)((Object)o1.myName), (Comparable)((Object)o2.myName)));
        set.addAll(this.myUsedExported);
        this.myUsedExported.clear();
        this.myUsedExported.addAll(set);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSStructuralDiagramItem item = (JSStructuralDiagramItem)o;
        if (this.myIsFile != item.myIsFile) {
            return false;
        }
        if (this.myIsInScope != item.myIsInScope) {
            return false;
        }
        if (this.myElementPointer != null ? !this.myElementPointer.equals(item.myElementPointer) : item.myElementPointer != null) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(item.myName) : item.myName != null) {
            return false;
        }
        if (this.myParent != null ? !this.myParent.equals(item.myParent) : item.myParent != null) {
            return false;
        }
        if (!this.myUsedExported.equals(item.myUsedExported)) {
            return false;
        }
        return !(this.myIcon != null ? !this.myIcon.equals(item.myIcon) : item.myIcon != null);
    }

    public int hashCode() {
        int result = this.myElementPointer != null ? this.myElementPointer.hashCode() : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        result = 31 * result + (this.myIsFile ? 1 : 0);
        return result;
    }

    public boolean isInScope() {
        return this.myIsInScope;
    }

    public JSStructuralDiagramItem setInScope(boolean inScope) {
        this.myIsInScope = inScope;
        return this;
    }

    public JSStructuralDiagramItem getParent() {
        return this.myParent;
    }

    public JSStructuralDiagramItem setParent(JSStructuralDiagramItem parent) {
        this.myParent = parent;
        return this;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }
}

