/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class JSInheritedLanguagesConfigurableProvider {
    public static final LanguageExtension<JSInheritedLanguagesConfigurableProvider> INSTANCE = new LanguageExtension("JavaScript.inheritedLanguagesConfigurableProvider");

    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    public boolean isBadExpressionStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "isBadExpressionStatement"));
        }
        return true;
    }

    public boolean isNeedToBeTerminated(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "isNeedToBeTerminated"));
        }
        return true;
    }

    public boolean isLHSExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "isLHSExpression"));
        }
        return false;
    }

    public boolean isCaseStatementInterrupted(JSStatement statement) {
        return false;
    }

    public boolean forConditionShouldUseVariables() {
        return true;
    }

    public boolean constructorCallWithoutNewActual() {
        return true;
    }

    public boolean unnecessaryBlockStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "unnecessaryBlockStatement"));
        }
        return true;
    }

    public boolean hasNonBlockBranch(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "hasNonBlockBranch"));
        }
        return false;
    }

    public boolean isRemoveUnnecessaryParenthesesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "isRemoveUnnecessaryParenthesesEnabled"));
        }
        return true;
    }

    public boolean isSimplifyBooleanFixEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "isSimplifyBooleanFixEnabled"));
        }
        return true;
    }

    public boolean shouldRenameFileWithClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "shouldRenameFileWithClass"));
        }
        return true;
    }

    protected PsiElement createExpressionFromText(@NotNull String text, @NotNull PsiElement element, boolean reportErrorIfFailed) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "createExpressionFromText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "createExpressionFromText"));
        }
        if (reportErrorIfFailed) {
            return JSChangeUtil.createExpressionWithContext(text, element).getPsi();
        }
        ASTNode node = JSChangeUtil.tryCreateExpressionWithContext(text, element);
        return node != null ? node.getPsi() : null;
    }

    protected PsiElement createStatementFromText(@NotNull String text, @NotNull PsiElement element) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "createStatementFromText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "createStatementFromText"));
        }
        return JSChangeUtil.createStatementFromText(element.getProject(), text, JSUtils.getDialect(element.getContainingFile())).getPsi();
    }

    public boolean isMultilineLiteral(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "isMultilineLiteral"));
        }
        return element instanceof JSStringTemplateExpression;
    }

    public String getMultilineLiteralContent(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/JSInheritedLanguagesConfigurableProvider", "getMultilineLiteralContent"));
        }
        return "`" + StringUtil.escapeChar((String)text, (char)'`') + "`";
    }

    public TextRange getRangeInElement(PsiElement element) {
        JSLiteralExpression literal = (JSLiteralExpression)element;
        int length = literal.getTextLength();
        if (literal.isQuotedLiteral() && length >= 2) {
            ASTNode quotedLiteralNode;
            ASTNode backquote;
            int startOffset = 1;
            if (element instanceof JSStringTemplateExpression && (backquote = (quotedLiteralNode = element.getNode()).findChildByType(JSTokenTypes.BACKQUOTE)) != null) {
                startOffset = backquote.getStartOffset() - quotedLiteralNode.getStartOffset() + 1;
            }
            return new TextRange(startOffset, length - 1);
        }
        return new TextRange(0, length);
    }

    public boolean supportsJavaScriptInjections() {
        return true;
    }
}

