/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptClassBase<StubT extends JSQualifiedStub<?>>
extends JSClassBase<StubT>
implements TypeScriptTypeParameterListOwner,
TypeScriptInterfaceClass<StubT>,
JSSuppressionHolder {
    private static final Key<ParameterizedCachedValue<JSClass[], JSClass>> SUPER_CLASSES_CACHE_KEY = Key.create((String)"ts.super.classes");
    private static final ParameterizedCachedValueProvider<JSClass[], JSClass> SUPER_CLASSES_CACHE_PROVIDER = param -> {
        JSReferenceList extendsList = param.getExtendsList();
        JSClass[] classes = extendsList != null ? extendsList.getReferencedClasses() : JSClass.EMPTY_ARRAY;
        return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    };

    protected TypeScriptClassBase(ASTNode node) {
        super(node);
    }

    public TypeScriptClassBase(StubT stub, IStubElementType<StubT, ?> aClass) {
        super(stub, aClass);
    }

    @Override
    @NotNull
    public JSClass[] getSuperClasses() {
        JSClass[] jSClassArray = (JSClass[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, SUPER_CLASSES_CACHE_KEY, SUPER_CLASSES_CACHE_PROVIDER, false, (Object)this);
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "getSuperClasses"));
        }
        return jSClassArray;
    }

    @Nullable
    public TypeScriptTypeParameterList getTypeParameterList() {
        return (TypeScriptTypeParameterList)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.TYPE_PARAMETER_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean toProcessMembers;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processDeclarations"));
        }
        ResolveProcessor resolveProcessor = TypeScriptClassBase.getResolveProcessor(processor);
        if (resolveProcessor != null && resolveProcessor.checkVisited(this)) {
            return true;
        }
        if (!TypeScriptClassBase.processTypeAndTypeParameters(processor, lastParent, this, state, place)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        boolean bl = toProcessMembers = resolveProcessor == null || !resolveProcessor.isToSkipClassDeclarationOnce() && resolveProcessor.isToProcessMembers();
        if (toProcessMembers) {
            if (!this.processMembers(processor, state, lastParent, place)) {
                return false;
            }
        } else {
            resolveProcessor.setToSkipClassDeclarationsOnce(false);
        }
        if (resolveProcessor == null || !((ResolveProcessor)processor).isToProcessHierarchy()) {
            return true;
        }
        int savedNestingLevel = 0;
        if (processor instanceof SinkResolveProcessor) {
            Object sink = ((SinkResolveProcessor)processor).getResultSink();
            savedNestingLevel = ((ResultSink)sink).getNestingLevel();
            ((ResultSink)sink).setNestingLevel(savedNestingLevel + 1);
        }
        boolean savedProcessStatics = resolveProcessor.getAccessibilityProcessingHandler().isProcessStatics();
        processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)this);
        try {
            JSClass[] superClasses = this.getSuperClasses();
            if (superClasses.length > 0) {
                Collection<JSClass> classCollection = TypeScriptUtil.resolveAliasesToClass(superClasses, true);
                for (JSClass aClass : classCollection) {
                    if (TypeScriptQualifiedItemProcessor.processNamespaceChildren(resolveProcessor, state, lastParent, place, (JSQualifiedNamedElement)aClass)) continue;
                    boolean bl2 = false;
                    return bl2;
                }
            }
            if (processor instanceof SinkResolveProcessor) {
                ((ResultSink)((SinkResolveProcessor)processor).getResultSink()).setNestingLevel(10);
            }
            resolveProcessor.getAccessibilityProcessingHandler().setProcessStatics(false);
            String baseClassName = this.getBaseClassName(savedProcessStatics);
            boolean bl3 = TypeScriptClassBase.processClassByQName(baseClassName, place, resolveProcessor, state, lastParent, place);
            return bl3;
        }
        finally {
            resolveProcessor.getAccessibilityProcessingHandler().setProcessStatics(savedProcessStatics);
            if (processor instanceof SinkResolveProcessor) {
                ((ResultSink)((SinkResolveProcessor)processor).getResultSink()).setNestingLevel(savedNestingLevel);
            }
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)this);
        }
    }

    @NotNull
    protected String getBaseClassName(boolean savedProcessStatics) {
        String string = savedProcessStatics || this.hasCallSignature() ? "Function" : "Object";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "getBaseClassName"));
        }
        return string;
    }

    @Nullable
    private static ResolveProcessor getResolveProcessor(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "getResolveProcessor"));
        }
        return processor instanceof ResolveProcessor ? (ResolveProcessor)processor : null;
    }

    public static boolean processTypeAndTypeParameters(PsiScopeProcessor processor, @Nullable PsiElement lastParent, @NotNull TypeScriptTypeParameterListOwner owner, @NotNull ResolveState state, @NotNull PsiElement place) {
        boolean typeContext;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processTypeAndTypeParameters"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processTypeAndTypeParameters"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processTypeAndTypeParameters"));
        }
        ResolveProcessor resolveProcessor = TypeScriptClassBase.getResolveProcessor(processor);
        boolean bl = typeContext = resolveProcessor != null && resolveProcessor.isTypeContext();
        if (typeContext || lastParent == null) {
            TypeScriptTypeParameterList typeParameterList;
            if (typeContext && lastParent != null && (typeParameterList = owner.getTypeParameterList()) != null && !typeParameterList.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!processor.execute((PsiElement)owner, state)) {
                return false;
            }
        }
        return true;
    }

    protected boolean hasCallSignature() {
        return false;
    }

    public static boolean processClassByQName(@NotNull String qName, @NotNull PsiElement resolvePlace, ResolveProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processClassByQName"));
        }
        if (resolvePlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvePlace", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "processClassByQName"));
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(qName, resolvePlace);
        for (JSQualifiedNamedElement element : elements) {
            if (!TypeScriptConfigService.Provider.isAccessible(place, (PsiElement)element) || TypeScriptQualifiedItemProcessor.processNamespaceChildren(processor, state, lastParent, place, element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSQualifiedStub stub = (JSQualifiedStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return TypeScriptPsiUtil.isTopLevelContainerMember((PsiElement)this);
    }

    @NotNull
    public TypeScriptFunction[] findFunctionsByNameAndKind(@Nullable String name, @Nullable JSFunction.FunctionKind kind) {
        Map<String, Object> functions = this.getFunctionsMap();
        Object o = functions.get(name);
        if (o instanceof TypeScriptFunction) {
            TypeScriptFunction[] typeScriptFunctionArray;
            TypeScriptFunction function = (TypeScriptFunction)o;
            if (kind == null || function.getKind() == kind) {
                TypeScriptFunction[] typeScriptFunctionArray2 = new TypeScriptFunction[1];
                typeScriptFunctionArray = typeScriptFunctionArray2;
                typeScriptFunctionArray2[0] = function;
            } else {
                typeScriptFunctionArray = TypeScriptFunction.EMPTY;
            }
            if (typeScriptFunctionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "findFunctionsByNameAndKind"));
            }
            return typeScriptFunctionArray;
        }
        if (o instanceof JSFunction[]) {
            List result = ContainerUtil.newSmartList();
            for (JSFunction fun : (JSFunction[])o) {
                if (!(fun instanceof TypeScriptFunction) || kind != null && fun.getKind() != kind) continue;
                result.add((TypeScriptFunction)fun);
            }
            TypeScriptFunction[] typeScriptFunctionArray = (TypeScriptFunction[])result.stream().toArray(TypeScriptFunction[]::new);
            if (typeScriptFunctionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "findFunctionsByNameAndKind"));
            }
            return typeScriptFunctionArray;
        }
        if (TypeScriptFunction.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "findFunctionsByNameAndKind"));
        }
        return TypeScriptFunction.EMPTY;
    }

    @NotNull
    public TypeScriptFunction[] findFunctionsByName(String name) {
        TypeScriptFunction[] typeScriptFunctionArray = this.findFunctionsByNameAndKind(name, null);
        if (typeScriptFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase", "findFunctionsByName"));
        }
        return typeScriptFunctionArray;
    }
}

