/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import icons.JavaScriptPsiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleImpl
extends JSQualifiedNamedElementBaseImpl<TypeScriptModuleStub>
implements TypeScriptModule<TypeScriptModuleStub> {
    private ThreeState myIsInstantiated = ThreeState.UNSURE;

    public TypeScriptModuleImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptModuleImpl(TypeScriptModuleStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.TYPESCRIPT_MODULE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptModule((TypeScriptModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return TypeScriptModuleImpl.findNameIdentifier(this.getNode());
    }

    @Nullable
    public static ASTNode findNameIdentifier(@NotNull ASTNode typeScriptModule) {
        if (typeScriptModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeScriptModule", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "findNameIdentifier"));
        }
        boolean wasKeyword = false;
        for (ASTNode element = typeScriptModule.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            IElementType type = element.getElementType();
            if (type == JSTokenTypes.LBRACE) {
                return null;
            }
            if (type == JSStubElementTypes.LITERAL_EXPRESSION) {
                return element;
            }
            if (!wasKeyword) {
                if (!JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS.contains(type)) continue;
                wasKeyword = true;
                continue;
            }
            if (!JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET.contains(type)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode nameIdentifier = this.findNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getPsi() : null;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return TypeScriptUtil.unifyModuleName(JSPsiImplUtils.getNamespace((JSNamedElement)this));
    }

    @Override
    public ItemPresentation getPresentation() {
        return new JSItemPresentation((JSPsiElementBase)this){

            @Override
            public String getPresentableText() {
                String text = super.getPresentableText();
                if (text == null) {
                    return null;
                }
                return StringUtil.unquoteString((String)text);
            }
        };
    }

    public String getName() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement element = this.getNameIdentifier();
        if (element instanceof JSLiteralExpression) {
            return TypeScriptUtil.unifyModuleName(element.getText());
        }
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode identifier = JSChangeUtil.createNameIdentifier(this.getProject(), name, JavaScriptSupportLoader.TYPESCRIPT);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, identifier);
        }
        return this;
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getNode().getStartOffset() : super.getTextOffset();
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent != this && !processor.execute((PsiElement)this, state)) {
            return false;
        }
        if (this.skipProcessingMembers(lastParent)) {
            return true;
        }
        if (!TypeScriptImportHandler.processES6DeclarationsInScope(this, processor, ResolveState.initial(), lastParent, place, false)) {
            return false;
        }
        return !(processor instanceof ResolveProcessor) || ((ResolveProcessor)processor).isLocalResolve() || this.processMergedElements(processor, lastParent, place);
    }

    public boolean skipProcessingMembers(PsiElement lastParent) {
        return lastParent == null;
    }

    private boolean processMergedElements(@NotNull PsiScopeProcessor processor, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "processMergedElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "processMergedElements"));
        }
        String name = this.getQualifiedName();
        if (name != null) {
            Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(name, (PsiElement)this);
            if (elements.size() == 1) {
                return true;
            }
            ES6PsiUtil.ES6ExportedElementsProcessor newProcessor = processor instanceof ES6PsiUtil.ES6ExportedElementsProcessor ? (ES6PsiUtil.ES6ExportedElementsProcessor)processor : new ES6PsiUtil.ES6ExportedElementsProcessor(processor);
            for (JSQualifiedNamedElement element : elements) {
                if (element == this || !(element instanceof TypeScriptModule) || JSResolveUtil.processDeclarationsInScope((JSElement)element, newProcessor, ResolveState.initial(), lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JavaScriptPsiIcons.Classes.Typescript_Module;
    }

    public boolean isInternal() {
        String name = this.getName();
        return name == null || !StringUtil.isQuotedString((String)name);
    }

    public boolean isInstantiated() {
        ThreeState instantiated = this.myIsInstantiated;
        if (instantiated == ThreeState.UNSURE) {
            boolean isInstantiated = this.isInstantiatedImpl();
            this.myIsInstantiated = instantiated = isInstantiated ? ThreeState.YES : ThreeState.NO;
        }
        return instantiated.toBoolean();
    }

    public boolean isGlobalScopeAugmentation() {
        return this.getName() == null;
    }

    public boolean isAugmentation() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAugmentation();
        }
        return TypeScriptAugmentationUtil.isExternalModuleAugmentation(this);
    }

    public boolean isShorthandAmbientModule() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.isShorthandAmbientModule();
        }
        return !this.isInternal() && this.getNode().findChildByType(JSTokenTypes.LBRACE) == null;
    }

    private boolean isInstantiatedImpl() {
        for (JSSourceElement element : JSResolveUtil.getSourceElements((PsiElement)this)) {
            if (!TypeScriptModuleImpl.checkNestedElementInstantiated((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNestedElementInstantiated(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "checkNestedElementInstantiated"));
        }
        if (!(element instanceof TypeScriptInterface || element instanceof TypeScriptModule || element instanceof TypeScriptTypeAlias)) {
            return true;
        }
        return element instanceof TypeScriptModule && ((TypeScriptModule)element).isInstantiated();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "getAccessType"));
        }
        return accessType;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.STATIC;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "getJSContext"));
        }
        return jSContext;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myIsInstantiated = ThreeState.UNSURE;
    }

    @NotNull
    public Map<String, JSReferenceExpression> getExtensionSymbols() {
        Map<String, JSReferenceExpression> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl", "getExtensionSymbols"));
        }
        return map;
    }
}

