/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.impl.JSParameterListImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterListStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class TypeScriptParameterListImpl
extends JSParameterListImpl {
    public TypeScriptParameterListImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptParameterListImpl(JSParameterListStub stub) {
        this(stub, (IStubElementType)TypeScriptElementTypes.TYPESCRIPT_PARAMETER_LIST);
    }

    public TypeScriptParameterListImpl(JSParameterListStub stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    @NotNull
    protected JSParameter[] calcParameters() {
        JSParameter[] parameters = super.calcParameters();
        JSParameter[] jSParameterArray = (JSParameter[])Arrays.stream(parameters).filter(p -> !TypeScriptPsiUtil.isThisParameter((JSParameterItem)p)).toArray(JSParameter[]::new);
        if (jSParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterListImpl", "calcParameters"));
        }
        return jSParameterArray;
    }

    @Override
    protected JSParameterListElement[] calcCallParameters() {
        JSParameterListElement[] parameters = super.calcCallParameters();
        return (JSParameterListElement[])Arrays.stream(parameters).filter(p -> !TypeScriptPsiUtil.isThisParameter((JSParameterItem)p)).toArray(JSParameterListElement[]::new);
    }

    @Override
    @NotNull
    public JSParameter[] getRawParameters() {
        JSParameter[] jSParameterArray = super.getRawParameters();
        if (jSParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterListImpl", "getRawParameters"));
        }
        return jSParameterArray;
    }
}

