/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSReferenceListStub;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceListImpl<T extends JSReferenceListStub<?>>
extends JSStubElementImpl<T>
implements JSReferenceList,
StubBasedPsiElement<T> {
    private static final Function<JSReferenceListMember, String> MEMBER_TO_STRING_REFERENCE = JSReferenceListMember::getReferenceText;
    protected static final Function<JSReferenceListMember, JSExpression> MEMBER_TO_EXPRESSION = JSReferenceListMember::getExpression;

    public JSReferenceListImpl(ASTNode node) {
        super(node);
    }

    public JSReferenceListImpl(T stub) {
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSReferenceList((JSReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public JSExpression[] getExpressions() {
        JSExpression[] jSExpressionArray = (JSExpression[])ContainerUtil.map2Array((Object[])this.getMembers(), JSExpression.class, MEMBER_TO_EXPRESSION);
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getExpressions"));
        }
        return jSExpressionArray;
    }

    @NotNull
    public String[] getReferenceTexts() {
        Object[] members = this.getMembers();
        if (members.length == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getReferenceTexts"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])ArrayUtil.stripTrailingNulls((Object[])ContainerUtil.map2Array((Object[])members, String.class, MEMBER_TO_STRING_REFERENCE));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getReferenceTexts"));
        }
        return stringArray;
    }

    protected JSReferenceListMember[] getMembers() {
        return (JSReferenceListMember[])this.getStubOrPsiChildren((IStubElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER, JSReferenceListMember.ARRAY_FACTORY);
    }

    @NotNull
    public JSClass[] getReferencedClasses() {
        String[] texts = this.getReferenceTexts();
        if (texts.length == 0) {
            if (JSClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getReferencedClasses"));
            }
            return JSClass.EMPTY_ARRAY;
        }
        ArrayList<JSClass> supers = new ArrayList<JSClass>(texts.length);
        JSImportHandler importHandler = this.getImportHandler();
        for (String text : texts) {
            supers.addAll(this.resolveTextReferenceClasses(importHandler, text));
        }
        JSClass[] jSClassArray = supers.toArray(new JSClass[supers.size()]);
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getReferencedClasses"));
        }
        return jSClassArray;
    }

    @NotNull
    protected JSImportHandler getImportHandler() {
        JSImportHandler jSImportHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).getImportHandler();
        if (jSImportHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getImportHandler"));
        }
        return jSImportHandler;
    }

    private Collection<JSClass> resolveTextReferenceClasses(JSImportHandler importHandler, String text) {
        return this.resolveReferenceClasses(importHandler.resolveTypeName(text, (PsiElement)this));
    }

    @NotNull
    protected Collection<JSClass> resolveReferenceClasses(JSTypeResolveResult resolveResult) {
        String text = resolveResult.getQualifiedName();
        if (DialectDetector.isActionScript((PsiElement)this)) {
            PsiElement clazz = JSClassResolver.findClassFromNamespace(text, (PsiElement)this, JSResolveUtil.getResolveScope((PsiElement)this));
            if (clazz instanceof JSClass) {
                List list = ContainerUtil.createMaybeSingletonList((Object)((JSClass)clazz));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "resolveReferenceClasses"));
                }
                return list;
            }
        } else {
            if (resolveResult.hasElements()) {
                PsiElement parentClass = this.getParent();
                List result = ContainerUtil.newSmartList();
                for (PsiElement psiElement : resolveResult.getElements()) {
                    if (!(psiElement instanceof JSClass) || parentClass == psiElement) continue;
                    result.add((JSClass)psiElement);
                }
                List list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "resolveReferenceClasses"));
                }
                return list;
            }
            if (!DialectDetector.isTypeScript((PsiElement)this)) {
                Collection<JSClass> collection = this.resolveDirectlyToClasses(text);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "resolveReferenceClasses"));
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "resolveReferenceClasses"));
        }
        return list;
    }

    @NotNull
    public Collection<Pair<JSReferenceListMember, Collection<JSClass>>> getResolvedExpressions() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getResolvedExpressions"));
            }
            return list;
        }
        JSImportHandler importHandler = this.getImportHandler();
        List resolvedList = ContainerUtil.newSmartList();
        for (JSReferenceListMember member : members) {
            String text = member.getReferenceText();
            if (text != null) {
                resolvedList.add(Pair.create((Object)member, this.resolveTextReferenceClasses(importHandler, text)));
                continue;
            }
            resolvedList.add(Pair.create((Object)member, null));
        }
        List list = resolvedList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "getResolvedExpressions"));
        }
        return list;
    }

    @NotNull
    protected Collection<JSClass> resolveDirectlyToClasses(String text) {
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).getClassResolver();
        List<JSClass> list = resolver.findClassesByQName(text, JSResolveUtil.getResolveScope((PsiElement)this));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl", "resolveDirectlyToClasses"));
        }
        return list;
    }
}

