/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSAssignmentExpressionStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAssignmentExpressionImpl
extends JSStubElementImpl<JSAssignmentExpressionStub>
implements JSAssignmentExpression,
StubBasedPsiElement<JSAssignmentExpressionStub> {
    public JSAssignmentExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSAssignmentExpressionImpl(JSAssignmentExpressionStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
    }

    public static boolean processBinaryExpressionDeclarations(@NotNull JSBinaryExpression expr, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSExpression roperand;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processBinaryExpressionDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processBinaryExpressionDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processBinaryExpressionDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processBinaryExpressionDeclarations"));
        }
        JSExpression loperand = expr.getLOperand();
        if (loperand != null && lastParent != loperand && lastParent != (roperand = expr.getROperand())) {
            boolean loperandResult;
            boolean bl = loperandResult = loperand instanceof JSDefinitionExpression ? processor.execute((PsiElement)loperand, state) : loperand.processDeclarations(processor, state, lastParent, place);
            if (!loperandResult) {
                return false;
            }
            if (roperand != null) {
                return roperand.processDeclarations(processor, state, lastParent, place);
            }
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSAssignmentExpression((JSAssignmentExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSAssignmentExpressionImpl", "processDeclarations"));
        }
        return JSAssignmentExpressionImpl.processBinaryExpressionDeclarations((JSBinaryExpression)this, processor, state, lastParent, place);
    }

    public JSExpression getLOperand() {
        ASTNode lOperandNode = JSBinaryExpressionImpl.getLOperandNode(this.getNode());
        return lOperandNode != null ? (JSExpression)lOperandNode.getPsi() : null;
    }

    public JSExpression getROperand() {
        ASTNode rOperandNode = JSBinaryExpressionImpl.getROperandNode(this.getNode());
        return rOperandNode != null ? (JSExpression)rOperandNode.getPsi() : null;
    }

    public IElementType getOperationSign() {
        ASTNode operationASTNode = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS);
        return operationASTNode != null ? operationASTNode.getElementType() : null;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Nullable
    public JSDefinitionExpression getDefinitionExpression() {
        return (JSDefinitionExpression)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
    }
}

