/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSObjectLiteralExpressionImpl
extends JSStubElementImpl<JSObjectLiteralExpressionStub>
implements JSObjectLiteralExpression,
StubBasedPsiElement<JSObjectLiteralExpressionStub> {
    private final TokenSet myPropertiesAndSpreads = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.PROPERTIES, TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.SPREAD_PROPERTY})});

    public JSObjectLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSObjectLiteralExpressionImpl(JSObjectLiteralExpressionStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    protected JSObjectLiteralExpressionImpl(JSObjectLiteralExpressionStub stub, IStubElementType type) {
        super(stub, type);
    }

    public JSProperty[] getProperties() {
        return (JSProperty[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.PROPERTIES, JSProperty.ARRAY_FACTORY);
    }

    public JSProperty getFirstProperty() {
        return (JSProperty)JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSExtendedLanguagesTokenSetProvider.PROPERTIES);
    }

    public JSProperty findProperty(String name) {
        if (name == null) {
            return null;
        }
        Collection<JSElement> namedElements = JSResolveUtil.findNamedElementsInScope(name, this);
        for (JSElement element : namedElements) {
            if (!(element instanceof JSProperty)) continue;
            return (JSProperty)element;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSObjectLiteralExpression((JSObjectLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.CLASS_ICON;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "processDeclarations"));
        }
        if (!(lastParent != null && place instanceof JSProperty || JSPropertyImpl.placeToProcessProperties(place))) {
            return true;
        }
        return JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "addBefore"));
        }
        PsiElement elt = super.addBefore(element, anchor);
        if (elt instanceof JSProperty) {
            super.addAfter(JSChangeUtil.createJSTreeFromText(this.getProject(), ",").getTreeNext().getPsi(), elt);
        }
        return elt;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @NotNull
    public Set<String> getExtendedTypes() {
        String s;
        JSReferenceExpression baseType;
        String lends;
        JSDocComment docComment;
        JSObjectLiteralExpressionStub stub = (JSObjectLiteralExpressionStub)this.getGreenStub();
        if (stub != null) {
            Set set = stub.getExtendedTypes();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "getExtendedTypes"));
            }
            return set;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof JSArgumentList) {
            JSNamespaceEvaluationResult localType;
            JSElement qualifyingExpression = JSSymbolUtil.findQualifyingExpressionFromArgumentList((JSArgumentList)parent);
            if (qualifyingExpression instanceof JSReferenceExpression && (localType = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifyingExpression)) != null) {
                qualifyingExpression = null;
            }
            if (qualifyingExpression != null) {
                THashSet baseTypes = new THashSet();
                if (qualifyingExpression.getParent() instanceof JSArrayLiteralExpression) {
                    for (JSExpression expr : ((JSArrayLiteralExpression)qualifyingExpression.getParent()).getExpressions()) {
                        String baseType2;
                        if (expr == null || expr.getClass() != qualifyingExpression.getClass() || (baseType2 = JSContextResolver.getQualifierOfExprAsString((JSElement)expr)) == null) continue;
                        baseTypes.add((Object)baseType2);
                    }
                } else {
                    String baseType3 = JSContextResolver.getQualifierOfExprAsString(qualifyingExpression);
                    if (baseType3 != null) {
                        baseTypes.add((Object)baseType3);
                    }
                }
                THashSet tHashSet = baseTypes;
                if (tHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "getExtendedTypes"));
                }
                return tHashSet;
            }
        }
        if ((docComment = JSDocumentationUtils.findOwnDocComment(this)) != null && (lends = docComment.getLendsTagValue()) != null) {
            Set<String> set = Collections.singleton(StringUtil.replace((String)lends, (String)".prototype", (String)"#"));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "getExtendedTypes"));
            }
            return set;
        }
        JSNamespaceEvaluationResult declarationNamespace = JSSymbolUtil.findNamespace((JSExpression)this);
        JSQualifiedName namespace = declarationNamespace != null ? declarationNamespace.getQualifiedName() : null;
        PsiElement scope = JSPsiImplUtils.getExecutionScope((PsiElement)this);
        if (namespace != null && namespace.getParent() == null && scope instanceof JSExecutionScope && (baseType = (JSReferenceExpression)((JSExecutionScope)scope).getExtensionSymbols().get(namespace.getName())) != null && (s = JSStubIndexingUtils.evaluateTypeString(baseType)) != null) {
            Set<String> set = Collections.singleton(s);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "getExtendedTypes"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "getExtendedTypes"));
        }
        return set;
    }

    @NotNull
    public JSElement[] getPropertiesIncludingSpreads() {
        JSElement[] jSElementArray = (JSElement[])this.getStubOrPsiChildren(this.myPropertiesAndSpreads, JSElement.ARRAY_FACTORY);
        if (jSElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSObjectLiteralExpressionImpl", "getPropertiesIncludingSpreads"));
        }
        return jSElementArray;
    }
}

