/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.manipulators;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class JSAbstractElementManipulator<T extends PsiElement>
extends AbstractElementManipulator<T> {
    public T handleContentChange(@NotNull T element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/manipulators/JSAbstractElementManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/psi/manipulators/JSAbstractElementManipulator", "handleContentChange"));
        }
        String newText = this.getNewText(element, range, newContent);
        JSLanguageDialect languageDialect = JSUtils.getDialect(element.getContainingFile());
        return (T)element.replace(this.createTree(newText, element, languageDialect, element.getProject()));
    }

    protected String getNewText(T element, TextRange range, String newContent) {
        String oldText = element.getText();
        StringBuilder sb = new StringBuilder(oldText.substring(0, range.getStartOffset()));
        StringUtil.escapeStringCharacters((int)newContent.length(), (String)newContent, (String)(oldText.startsWith("'") ? "'" : "'\""), (StringBuilder)sb);
        return sb.append(oldText.substring(range.getEndOffset())).toString();
    }

    protected abstract T createTree(String var1, T var2, JSLanguageDialect var3, Project var4);
}

