/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.manipulators;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.manipulators.JSAbstractElementManipulator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSLiteralManipulator
extends JSAbstractElementManipulator<JSLiteralExpression> {
    @Override
    public JSLiteralExpression handleContentChange(@NotNull JSLiteralExpression element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator", "handleContentChange"));
        }
        if (newContent.isEmpty() && element.isRegExpLiteral()) {
            return null;
        }
        return super.handleContentChange(element, range, newContent);
    }

    @Override
    protected JSLiteralExpression createTree(String newText, JSLiteralExpression context, JSLanguageDialect languageDialect, Project project) {
        PsiElement newExpr;
        PsiElement child;
        String fullText = newText;
        if (context instanceof JSStringTemplateExpression && (child = context.getFirstChild()) instanceof JSReferenceExpression) {
            fullText = child.getText() + newText;
        }
        return (newExpr = JSInheritedLanguagesHelper.createExpressionFromText(fullText, (PsiElement)context, false)) instanceof JSLiteralExpression ? (JSLiteralExpression)newExpr : context;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JSLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator", "getRangeInElement"));
        }
        int length = element.getTextLength();
        if (JSInheritedLanguagesHelper.isMultilineLiteral((PsiElement)element)) {
            TextRange textRange = JSInheritedLanguagesHelper.getRangeInElement((PsiElement)element);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        if (element.isQuotedLiteral() && length >= 2) {
            TextRange textRange = new TextRange(1, length - 1);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    @Override
    protected String getNewText(JSLiteralExpression element, TextRange range, String newContent) {
        if (JSInheritedLanguagesHelper.isMultilineLiteral((PsiElement)element)) {
            return JSInheritedLanguagesHelper.getMultilineLiteralContent((PsiElement)element, newContent);
        }
        if (element.isRegExpLiteral()) {
            String oldText = element.getText();
            StringBuilder sb = new StringBuilder(oldText.substring(0, range.getStartOffset()));
            JSLiteralManipulator.escapeRegex(newContent, sb);
            return sb.append(oldText.substring(range.getEndOffset())).toString();
        }
        return super.getNewText(element, range, newContent);
    }

    private static void escapeRegex(String text, StringBuilder out) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '/') {
                if (i > 0 && text.charAt(i - 1) != '\\') {
                    out.append("\\/");
                    continue;
                }
                out.append("/");
                continue;
            }
            out.append(c);
        }
    }
}

