/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptResolveUtil {
    @NonNls
    private static final String SCRIPT_TAG_NAME = "Script";
    public static final String ADD_EVENT_LISTENER_METHOD = "addEventListener";
    public static final String REMOVE_EVENT_LISTENER_METHOD = "removeEventListener";
    private static final List<Class<? extends JSElement>> ANONYMOUS_EVENT_LISTENER_CLASSES = Arrays.asList(JSFunctionExpression.class, JSParenthesizedExpression.class, JSCallExpression.class, JSExpressionStatement.class, JSFile.class);
    private static final TokenSet mainDeclaredElementTokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CLASS, ActionScriptElementTypes.FUNCTION_DECLARATION, JSStubElementTypes.NAMESPACE_DECLARATION}), JSElementTypes.VAR_STATEMENTS});
    @NonNls
    public static final String FLASH_EVENTS_IEVENT_DISPATCHER = "flash.events.IEventDispatcher";

    public static boolean isAnonymousEventHandlerTag(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlText && !SCRIPT_TAG_NAME.equals(((XmlTag)context.getParent()).getLocalName());
    }

    public static boolean isAnonymousEventHandlerAttribute(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlAttributeValue;
    }

    public static boolean isAnonymousEventHandler(JSFunctionExpression expr) {
        JSFile file = (JSFile)ActionScriptResolveUtil.iterateUp((PsiElement)expr, ANONYMOUS_EVENT_LISTENER_CLASSES);
        return file != null && (ActionScriptResolveUtil.isAnonymousEventHandlerTag(file) || ActionScriptResolveUtil.isAnonymousEventHandlerAttribute(file));
    }

    @Nullable
    public static <T> T computeIfInsideAnonymousEventHandler(PsiElement psiElement, Function<JSFunctionExpression, T> function) {
        while (psiElement instanceof JSExpression) {
            psiElement = psiElement.getParent();
        }
        if (psiElement instanceof JSArgumentList) {
            JSExpression methodExpression = ((JSCallExpression)psiElement.getParent()).getMethodExpression();
            if (methodExpression instanceof JSParenthesizedExpression) {
                methodExpression = ((JSParenthesizedExpression)methodExpression).getInnerExpression();
            }
            if (methodExpression instanceof JSFunctionExpression && ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)methodExpression)) {
                return (T)function.fun((Object)((JSFunctionExpression)methodExpression));
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement iterateUp(PsiElement element, List<Class<? extends JSElement>> classes) {
        Iterator<Class<? extends JSElement>> i = classes.iterator();
        while (i.hasNext()) {
            if (element == null || !i.next().isInstance(element)) {
                return null;
            }
            if (!i.hasNext()) continue;
            element = element.getParent();
        }
        return element;
    }

    public static <E extends PsiElement> void processIncludedFiles(TokenSet filter, JSFile file, ArrayList<E> result, Collection<JSFile> visited) {
        if (visited.contains(file)) {
            return;
        }
        visited.add(file);
        for (PsiElement element : JSResolveUtil.getStubbedChildren((PsiElement)file, filter)) {
            if (element instanceof JSIncludeDirective) {
                PsiFile includedFile = ((JSIncludeDirective)element).resolveFile();
                if (!(includedFile instanceof JSFile)) continue;
                ActionScriptResolveUtil.processIncludedFiles(filter, (JSFile)includedFile, result, visited);
                continue;
            }
            result.add(element);
        }
    }

    public static boolean isImplicitlyDeclaringEventDispatcher(JSAttributeList attributeList) {
        return attributeList != null && attributeList.getAttributesByName("Bindable").length != 0;
    }

    public static String replaceInternalName(String name) {
        return "Vector$object".equals(name) ? "Vector" : name;
    }

    public static boolean checkProcessFunctionPreconditions(@NotNull JSFunction function, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        boolean resolvingNewExpressionInOtherASClass;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil", "checkProcessFunctionPreconditions"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil", "checkProcessFunctionPreconditions"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil", "checkProcessFunctionPreconditions"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil", "checkProcessFunctionPreconditions"));
        }
        if (!Boolean.TRUE.equals(state.get(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT)) && ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)function)) {
            return true;
        }
        boolean bl = resolvingNewExpressionInOtherASClass = DialectDetector.isActionScript((PsiElement)function.getContainingFile()) && processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isTypeContext() && place instanceof JSReferenceExpression && place.getParent() instanceof JSNewExpression && JSResolveUtil.getClassOfContext(place) != JSResolveUtil.getClassOfContext((PsiElement)function);
        return resolvingNewExpressionInOtherASClass && function.isConstructor();
    }

    public static boolean hasExcludeClassMetadata(@NotNull JSAttributeListOwner attributeListOwner) {
        if (attributeListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeListOwner", "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil", "hasExcludeClassMetadata"));
        }
        JSAttributeList attributeList = attributeListOwner.getAttributeList();
        return attributeList != null && attributeList.findAttributeByName("ExcludeClass") != null;
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor) {
        return ActionScriptResolveUtil.processMetaAttributesForClass(jsClass, processor, true);
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, boolean withIncludedFiles) {
        return ActionScriptResolveUtil.doProcessMetaAttributesForClass(jsClass, processor, null, true, withIncludedFiles);
    }

    private static boolean doProcessMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, PsiElement lastParent, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements;
        if (jsClass instanceof JSClass) {
            PsiElement current;
            int ind;
            if ("Object".equals(((JSClass)jsClass).getQualifiedName())) {
                return true;
            }
            elements = JSResolveUtil.getStubbedChildren(jsClass.getContext());
            for (ind = elements.length - 1; ind >= 0 && elements[ind] != jsClass; --ind) {
            }
            --ind;
            while (ind >= 0 && (current = elements[ind]) instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, jsClass, (JSIncludeDirective)current, false)) {
                    return false;
                }
                --ind;
            }
            JSAttributeList attributeList = ((JSClass)jsClass).getAttributeList();
            if (attributeList != null && !ActionScriptResolveUtil.processAttributeList(processor, jsClass, attributeList, true, withIncludedFiles)) {
                return false;
            }
        }
        elements = JSResolveUtil.getStubbedChildren(jsClass);
        Ref continuePassElement = new Ref();
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement el = elements[i];
            if (el instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, lastParent, (JSIncludeDirective)el, forward)) {
                    return false;
                }
            } else if (el instanceof JSAttributeList) {
                if (!ActionScriptResolveUtil.processAttributeList(processor, lastParent, (JSAttributeList)el, forward, withIncludedFiles)) {
                    return false;
                }
            } else {
                JSAttributeList attributeList;
                continuePassElement.set(null);
                if (!processor.handleOtherElement(el, jsClass, (Ref<PsiElement>)continuePassElement)) {
                    return false;
                }
                PsiElement nextEl = (PsiElement)continuePassElement.get();
                if (nextEl instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)nextEl).getAttributeList()) != null && !ActionScriptResolveUtil.processAttributeList(processor, nextEl, attributeList, forward, withIncludedFiles)) {
                    return false;
                }
            }
            i += forward ? 1 : -1;
        }
        return true;
    }

    private static boolean processIncludeDirective(MetaDataProcessor processor, PsiElement lastParent, JSIncludeDirective el, boolean forward) {
        PsiFile file = el.resolveFile();
        return !(file instanceof JSFile) || ActionScriptResolveUtil.doProcessMetaAttributesForClass((PsiElement)file, processor, lastParent, forward, true);
    }

    public static boolean processAttributeList(MetaDataProcessor processor, PsiElement el, JSAttributeList attributeList, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements = JSResolveUtil.getStubbedChildren((PsiElement)attributeList);
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement cur = elements[i];
            if (cur instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, el, (JSIncludeDirective)cur, forward)) {
                    return false;
                }
            } else if (cur instanceof JSAttribute) {
                if (!processor.process((JSAttribute)cur)) {
                    return false;
                }
            } else if (cur instanceof JSNamedElement) break;
            i += forward ? 1 : -1;
        }
        return processor.handleOtherElement((PsiElement)attributeList, el, null);
    }

    public static boolean fieldIsImplicitAccessorMethod(JSFunction fun, JSVariable var) {
        JSAttributeList clazzAttributeList;
        if (!fun.isGetProperty() && !fun.isSetProperty()) {
            return false;
        }
        PsiElement funParent = JSResolveUtil.findParent((PsiElement)fun);
        if (!(funParent instanceof JSClass) || !((JSClass)funParent).isInterface()) {
            return false;
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)var);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSAttributeList attributeList = var.getAttributeList();
        if (attributeList == null || attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        JSClass clazz = (JSClass)parent;
        if (attributeList.findAttributeByName("Bindable") == null && ((clazzAttributeList = clazz.getAttributeList()) == null || clazzAttributeList.findAttributeByName("Bindable") == null)) {
            return false;
        }
        for (JSClass c : clazz.getImplementedInterfaces()) {
            if (c != funParent) continue;
            return true;
        }
        return false;
    }

    public static boolean weShouldSkipResolveBecauseOfImplicitClass(PsiElement elt) {
        if (elt == null) {
            return false;
        }
        PsiElement responsibleElement = elt instanceof JSFile ? elt : elt.getParent();
        return responsibleElement instanceof JSFile && DialectDetector.isActionScript(responsibleElement) && responsibleElement.getContext() != null;
    }

    public static String findPackageForMxml(PsiElement expression) {
        String s = null;
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 && containingFile.getContext() != null) {
            PsiFile contextContainigFile = containingFile.getContext().getContainingFile();
            VirtualFile file = contextContainigFile.getOriginalFile().getVirtualFile();
            s = JSResolveUtil.getExpectedPackageNameFromFile(file, containingFile.getProject());
        }
        return s;
    }

    @Nullable
    public static JSNamedElement findMainDeclaredElement(@NotNull PsiFileImpl file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil", "findMainDeclaredElement"));
        }
        JSNamedElement mainDeclaredElement = null;
        StubElement stub = file.getStub();
        if (stub != null) {
            StubElement packageStub = stub.findChildStubByType(JSStubElementTypes.PACKAGE_STATEMENT);
            if (packageStub != null) {
                StubElement qualifiedElement = packageStub.findChildStubByType((IStubElementType)JSStubElementTypes.CLASS);
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByType(ActionScriptElementTypes.FUNCTION_DECLARATION);
                }
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByType(JSStubElementTypes.NAMESPACE_DECLARATION);
                }
                if (qualifiedElement == null && (qualifiedElement = packageStub.findChildStubByType(JSStubElementTypes.VAR_STATEMENT)) != null) {
                    qualifiedElement = qualifiedElement.findChildStubByType(ActionScriptElementTypes.VARIABLE);
                }
                if (qualifiedElement != null) {
                    mainDeclaredElement = (JSNamedElement)qualifiedElement.getPsi();
                }
            }
        } else {
            JSPackageStatement statement = (JSPackageStatement)file.findChildByClass(JSPackageStatement.class);
            if (statement != null) {
                ASTNode node = statement.getNode().findChildByType(mainDeclaredElementTokenSet);
                if (node != null && node.getElementType() == JSStubElementTypes.VAR_STATEMENT) {
                    node = node.findChildByType(ActionScriptElementTypes.VARIABLE);
                }
                if (node != null) {
                    mainDeclaredElement = (JSNamedElement)node.getPsi();
                }
            }
        }
        return mainDeclaredElement;
    }

    public static interface MetaDataProcessor {
        public boolean process(@NotNull JSAttribute var1);

        public boolean handleOtherElement(PsiElement var1, PsiElement var2, @Nullable Ref<PsiElement> var3);
    }
}

