/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitJSVariableImpl
extends LightElement
implements JSVariable {
    private final PsiElement myParent;
    private final String myName;
    private final JSType myType;
    private final JSAttributeList.AccessType myAccessType;

    public ImplicitJSVariableImpl(String name, String type, @NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "<init>"));
        }
        this(name, type, JSAttributeList.AccessType.PRIVATE, parent);
    }

    public ImplicitJSVariableImpl(String name, String type, JSAttributeList.AccessType accessType, @NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "<init>"));
        }
        super(parent.getManager(), DialectDetector.languageOfElement(parent));
        this.myName = name;
        this.myAccessType = accessType;
        this.myParent = parent;
        this.myType = JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)this, true), JSContext.INSTANCE);
    }

    public ImplicitJSVariableImpl(String name, @Nullable JSType type, PsiElement parent) {
        super(parent.getManager(), (Language)JavascriptLanguage.INSTANCE);
        this.myName = name;
        this.myType = type;
        this.myAccessType = JSAttributeList.AccessType.PRIVATE;
        this.myParent = parent;
    }

    public JSAttributeList getAttributeList() {
        return null;
    }

    public boolean isValid() {
        return this.myParent.isValid();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiFile getContainingFile() {
        return this.myParent.getContainingFile();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSVariable((JSVariable)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement copy() {
        return new ImplicitJSVariableImpl(this.myName, this.myType, this.myParent);
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean isPhysical() {
        return false;
    }

    public IStubElementType getElementType() {
        return JSStubElementTypes.VARIABLE;
    }

    public JSVariableStubBase getStub() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public JSExpression getInitializer() {
        return null;
    }

    public JSExpression getInitializerOrStub() {
        return this.getInitializer();
    }

    @Nullable
    public String getLiteralOrReferenceInitializerText() {
        return null;
    }

    public void setInitializer(JSExpression expr) throws IncorrectOperationException {
    }

    @Nullable
    public JSType getType() {
        return this.myType;
    }

    @Deprecated
    public String getTypeString() {
        return this.myType == null ? "*" : this.myType.getTypeText();
    }

    public PsiElement getTypeElement() {
        return null;
    }

    public boolean isConst() {
        return false;
    }

    public boolean isLocal() {
        return PsiTreeUtil.getParentOfType((PsiElement)this.myParent, JSFunction.class) != null;
    }

    public boolean hasBlockScope() {
        return false;
    }

    public boolean isDeprecated() {
        return false;
    }

    public PsiElement getDeclarationScope() {
        return this.myParent;
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public ASTNode findNameIdentifier() {
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "setName"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement getNameIdentifier() {
        return null;
    }

    public String toString() {
        return "js_implicit_var:" + this.myName + ", type:" + this.myType + ", parent:" + this.myParent;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return another == this || another instanceof ImplicitJSVariableImpl && this.myParent == ((ImplicitJSVariableImpl)another).myParent && this.myName.equals(((ImplicitJSVariableImpl)another).myName);
    }

    public Icon getIcon(int flags) {
        return ElementBase.iconWithVisibilityIfNeeded((int)flags, (Icon)PlatformIcons.VARIABLE_ICON, (Icon)this.myAccessType.getIcon());
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "getJSContext"));
        }
        return jSContext;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return JSPsiImplUtils.buildNamespaceFromQualifiedName((JSQualifiedNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "getAccessType"));
        }
        return accessType;
    }

    @Nullable
    public JSFunctionExpression tryGetFunctionExpressionInitializer() {
        return null;
    }

    public ItemPresentation getPresentation() {
        return new JSItemPresentation((JSPsiElementBase)this);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.getNamespace(), this.getJSContext(), this.isNamespaceExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ImplicitJSVariableImpl", "getJSNamespace"));
        }
        return jSNamespaceImpl;
    }
}

