/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportHandler {
    private static final JSImportHandler INSTANCE = new JSImportHandler();

    protected JSImportHandler() {
    }

    public static JSImportHandler getInstance() {
        return INSTANCE;
    }

    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "getQualifiedNameResolvedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "getQualifiedNameResolvedType"));
        }
        return this.resolveTypeName(type, context).getQualifiedName();
    }

    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveTypeName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveTypeName"));
        }
        return this.resolveName(type, context);
    }

    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveName"));
        }
        PsiElement element = JSStubBasedPsiTreeUtil.resolveLocally(type, context);
        if (element instanceof JSVariable) {
            String text;
            String qualifiedName = ((JSVariable)element).getQualifiedName();
            if (qualifiedName != null) {
                type = qualifiedName;
            }
            if ((text = ((JSVariable)element).getLiteralOrReferenceInitializerText()) != null && !StringUtil.isQuotedString((String)text)) {
                boolean looksLikeTypeAlias = true;
                int dotIndex = text.indexOf(46);
                if (dotIndex > 0) {
                    PsiElement qualifierResolve = JSStubBasedPsiTreeUtil.resolveLocally(text.substring(0, dotIndex), element);
                    boolean bl = looksLikeTypeAlias = qualifierResolve == null;
                }
                if (looksLikeTypeAlias) {
                    JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(text, Collections.singleton(element));
                    if (jSTypeResolveResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveName"));
                    }
                    return jSTypeResolveResult;
                }
            }
        }
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveName"));
        }
        return jSTypeResolveResult;
    }

    @Nullable
    public JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/resolve/JSImportHandler", "resolveTypeNameUsingImports"));
        }
        return null;
    }

    public boolean importClass(PsiScopeProcessor processor, PsiNamedElement parent) {
        return true;
    }
}

