/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.annotations.NotNull;

public class JSPropertyNameResolver
implements ResolveCache.PolyVariantResolver<JSPropertyNameReference> {
    @NotNull
    public ResolveResult[] resolve(@NotNull JSPropertyNameReference reference, boolean incompleteCode) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver", "resolve"));
        }
        JSProperty property = reference.getElement();
        JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSObjectLiteralExpression)property.getParent()));
        String name = property.getName();
        if (name != null && type != null) {
            QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.TYPESCRIPT).createQualifiedItemProcessor((PsiElement)property, name);
            processor.process(type, new JSEvaluateContext(property.getContainingFile()), (PsiElement)property);
            ResolveResult[] results = processor.getResultsAsResolveResults();
            if (results.length > 0) {
                if (results == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver", "resolve"));
                }
                return results;
            }
        }
        ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)property)};
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver", "resolve"));
        }
        return resolveResultArray;
    }
}

