/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceUtil {
    public static boolean isReferenceTo(@NotNull PsiPolyVariantReference reference, @Nullable String referencedName, @NotNull PsiElement _element) {
        String elementName;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil", "isReferenceTo"));
        }
        if (_element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_element", "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil", "isReferenceTo"));
        }
        boolean processingSourceRefFromLibrary = false;
        if (_element instanceof JSImplicitElement) {
            elementName = ((JSImplicitElement)_element).getName();
        } else if (_element instanceof JSNamedElement) {
            ProjectFileIndex index;
            elementName = ((PsiNamedElement)_element).getName();
            PsiFile containingFile = _element.getContainingFile();
            if (containingFile != null && containingFile.getVirtualFile() != null && !DialectDetector.isTypeScript(_element) && (index = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex()).isInLibrarySource(containingFile.getVirtualFile())) {
                processingSourceRefFromLibrary = true;
            }
        } else if (_element instanceof XmlAttributeValue) {
            elementName = ((XmlAttributeValue)_element).getValue();
        } else if (_element instanceof PsiFile) {
            VirtualFile file = ((PsiFile)_element).getVirtualFile();
            elementName = file != null ? file.getNameWithoutExtension() : null;
        } else if (_element instanceof PsiDirectoryContainer) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof JSNamedElementBase) {
            elementName = ((JSNamedElementBase)_element).getName();
        } else if (_element instanceof PsiNamedElement && "JAVA".equals(_element.getLanguage().getID()) && DialectDetector.getLanguageDialect(reference.getElement()) == JavaScriptSupportLoader.NASHORN_JS) {
            elementName = ((PsiNamedElement)_element).getName();
        } else {
            return false;
        }
        if (!Comparing.equal((String)referencedName, (String)elementName, (boolean)true)) {
            return false;
        }
        ResolveResult[] resolveResults = reference.multiResolve(false);
        if (_element instanceof JSImplicitElement) {
            return JSReferenceUtil.checkImplicitElement(_element, resolveResults);
        }
        boolean skipDynamicResults = false;
        boolean skipAnyResults = false;
        boolean skipDynamicResultsCalculated = false;
        for (ResolveResult r : resolveResults) {
            ResolveResult[] results;
            PsiReference variableReference;
            JSVariable variable;
            PsiElement parent;
            PsiElement resolvedElement;
            if ((!skipDynamicResultsCalculated || skipDynamicResults || skipAnyResults) && reference instanceof JSReferenceExpression) {
                if (!skipDynamicResultsCalculated) {
                    PsiFile containingFile = reference.getElement().getContainingFile();
                    if (containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                        JSAttributeList attributeList;
                        JSExpression qualifier = ((JSReferenceExpressionImpl)reference).getResolveQualifier();
                        JSClass jsClass = null;
                        if (qualifier != null) {
                            String expressionType = JSResolveUtil.getQualifiedExpressionType(qualifier, containingFile);
                            if ("*".equals(expressionType)) {
                                skipAnyResults = true;
                            } else if (expressionType != null) {
                                PsiElement qName;
                                PsiElement psiElement = qName = expressionType != null ? JSClassResolver.findClassFromNamespace(expressionType, (PsiElement)containingFile) : null;
                                if (qName instanceof JSClass) {
                                    jsClass = (JSClass)qName;
                                }
                            }
                        } else {
                            jsClass = JSResolveUtil.getClassOfContext(reference.getElement());
                        }
                        if (jsClass != null && (attributeList = jsClass.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
                            skipDynamicResults = true;
                        }
                    }
                    skipDynamicResultsCalculated = true;
                }
                if (!r.isValidResult() && skipDynamicResults || skipAnyResults) continue;
            }
            if ((resolvedElement = r.getElement()) instanceof ES6Property && ((ES6Property)resolvedElement).isShorthanded()) {
                PsiElement resolve;
                JSExpression value = ((ES6Property)resolvedElement).getValue();
                if (value instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)value).resolve()) != null) {
                    if (JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                        return true;
                    }
                    resolvedElement = resolve;
                }
            } else if (resolvedElement instanceof JSVariable && (parent = (variable = (JSVariable)resolvedElement).getParent()) instanceof JSDestructuringShorthandedProperty && (variableReference = parent.getReference()) instanceof JSDestructuringPropertyReference && (results = ((JSDestructuringPropertyReference)variableReference).multiResolve(false)).length > 0) {
                if (JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                    return true;
                }
                PsiElement finalResolveElement = resolvedElement;
                Collection filteredResult = Arrays.stream(results).filter(result -> result != null && result.isValidResult()).map(ResolveResult::getElement).filter(psiElementResult -> psiElementResult != null && psiElementResult != finalResolveElement).collect(Collectors.toList());
                if (filteredResult.size() == 1) {
                    resolvedElement = (PsiElement)ContainerUtil.getFirstItem((Collection)filteredResult);
                }
            }
            if (resolvedElement instanceof JSOffsetBasedImplicitElement) {
                resolvedElement = ((JSOffsetBasedImplicitElement)resolvedElement).getElementAtOffset();
            }
            if (resolvedElement == null) continue;
            if (processingSourceRefFromLibrary) {
                resolvedElement = resolvedElement.getNavigationElement();
            }
            if (JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                return true;
            }
            if (resolvedElement instanceof JSFunctionExpression) {
                ASTNode treeParent;
                ASTNode nameIdentifier = ((JSFunctionExpression)resolvedElement).findNameIdentifier();
                if (nameIdentifier != null && ((treeParent = nameIdentifier.getTreeParent()).getPsi() == _element || treeParent.getTreeParent().getPsi() == _element)) {
                    return true;
                }
            } else if (JSClassUtils.isPossibleHierarchyMember(resolvedElement)) {
                if (JSResolveUtil.isConstructorFunction(resolvedElement) && _element instanceof JSClass && _element.isEquivalentTo((PsiElement)JSUtils.getMemberContainingClass(resolvedElement)) && !JSResolveUtil.isSelfReference(reference.getElement())) {
                    return true;
                }
                if (JSClassUtils.isPossibleHierarchyMember(_element)) {
                    JSClass resolvedElementParent = JSUtils.getMemberContainingClass(resolvedElement);
                    JSClass elementParent = JSUtils.getMemberContainingClass(_element);
                    if (elementParent != null && resolvedElementParent != null && !JSResolveUtil.isSelfReference(reference.getElement()) && JSInheritanceUtil.checkMemberHierarchyIncludeClass((JSPsiElementBase)resolvedElement, elementParent)) {
                        return true;
                    }
                }
            }
            if (TypeScriptPsiUtil.isImplementationAndOverloadFunction(_element, resolvedElement)) {
                return true;
            }
            if (!(resolvedElement instanceof JSClass) && !(resolvedElement instanceof JSNamespaceDeclaration) && !(resolvedElement instanceof JSFunction) && !(resolvedElement instanceof JSVariable) || (!(_element instanceof XmlFile) || resolvedElement.getParent().getContainingFile() != _element) && (!(_element instanceof JSFile) || reference.getElement().getParent() == resolvedElement || !JSReferenceUtil.isPublicEntityReferenceToJSFile(resolvedElement, _element))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkElementsAreEquialent(@NotNull PsiElement _element, @NotNull PsiElement resolvedElement) {
        if (_element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_element", "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil", "checkElementsAreEquialent"));
        }
        if (resolvedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedElement", "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil", "checkElementsAreEquialent"));
        }
        return resolvedElement.isEquivalentTo(_element) || _element.isEquivalentTo(resolvedElement) || (_element instanceof JSProperty || _element instanceof XmlAttributeValue) && resolvedElement.getParent() == _element;
    }

    private static boolean isPublicEntityReferenceToJSFile(PsiElement resolvedElement, PsiElement element) {
        PsiElement parent = resolvedElement.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        return parent instanceof JSPackageStatement && parent.getParent() == element;
    }

    private static boolean checkImplicitElement(PsiElement _element, ResolveResult[] resolveResults) {
        for (ResolveResult resolveResult : resolveResults) {
            PsiElement resolved = resolveResult.getElement();
            if (!_element.isEquivalentTo(resolved)) continue;
            return true;
        }
        return false;
    }
}

