/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAccessibilityChecker
extends JSAccessibilityChecker {
    public static final ES6ImportAccessibilityChecker INSTANCE = new ES6ImportAccessibilityChecker();
    private static final Collection<Class<? extends JSElement>> myClasses = ContainerUtil.newArrayList((Object[])new Class[]{JSVariable.class, JSFunction.class, ES6ImportSpecifier.class, ES6ImportSpecifierAlias.class, ES6Class.class, TypeScriptClass.class, TypeScriptModule.class, TypeScriptImportStatement.class, TypeScriptInterface.class, TypeScriptEnum.class, TypeScriptTypeAlias.class});

    @Override
    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        Collection<Class<? extends JSElement>> collection = myClasses;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/accessibility/ES6ImportAccessibilityChecker", "getSuitableClasses"));
        }
        return collection;
    }

    @Override
    @Nullable
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/ES6ImportAccessibilityChecker", "checkImpl"));
        }
        if (place != null) {
            if (!ES6PsiUtil.isElementCanBeExported(element)) {
                return null;
            }
            PsiFile elementFile = element.getContainingFile();
            if (!elementFile.isEquivalentTo((PsiElement)place.getContainingFile()) && element instanceof JSElement && !ES6ImportHandler.isExported(element)) {
                return "javascript.element.need.to.be.exported";
            }
        }
        return null;
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return false;
    }
}

