/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigAccessibilityChecker
extends JSAccessibilityChecker {
    public static final TypeScriptConfigAccessibilityChecker INSTANCE = new TypeScriptConfigAccessibilityChecker();
    private static final Collection<Class<? extends JSElement>> myClasses = ContainerUtil.newArrayList((Object[])new Class[]{JSVariable.class, JSFunction.class, JSField.class, ES6ImportSpecifier.class, JSClass.class});

    @Override
    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        Collection<Class<? extends JSElement>> collection = myClasses;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptConfigAccessibilityChecker", "getSuitableClasses"));
        }
        return collection;
    }

    @Override
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptConfigAccessibilityChecker", "checkImpl"));
        }
        if (place == null) {
            return null;
        }
        if (place instanceof ES6ImportSpecifier) {
            return null;
        }
        PsiFile placeContainingFile = place.getContainingFile();
        PsiFile elementContainingFile = element.getContainingFile();
        if (placeContainingFile == null || elementContainingFile == null) {
            return null;
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)elementContainingFile)) {
                return null;
            }
            PsiElement module = TypeScriptPsiUtil.findExternalModule(element);
            if (module != null) {
                return null;
            }
        }
        VirtualFile scope = placeContainingFile.getOriginalFile().getVirtualFile();
        VirtualFile referencedFile = elementContainingFile.getOriginalFile().getVirtualFile();
        if (scope == null || referencedFile == null) {
            return null;
        }
        if (!TypeScriptConfigService.Provider.isAccessible(place.getProject(), scope, referencedFile)) {
            return "javascript.element.need.to.be.included.to.config";
        }
        return null;
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return ((ResultSink)resolveProcessor.getResultSink()).isTypeScript();
    }
}

